import com.xhaus.jyson.JysonCodec as Json
from com.xebialabs.deployit.util import PasswordEncrypter
from xlrelease.HttpRequest import HttpRequest
from com.xebialabs.deployit.security import Permissions

class SupersetServer:
    def __init__(self, configuration):
        if configuration is None:
            self._error('No Digital.ai Intelligence server connection configured')
        self.connection = {'url': configuration.url, 'authenticationMethod': configuration.authenticationMethod,
                           'domain': configuration.domain,
                           'oauth2GrantType': configuration.oauth2GrantType, 'accessTokenUrl': configuration.accessTokenUrl, 'clientId': configuration.clientId,
                           'clientSecret': PasswordEncrypter.getInstance().ensureDecrypted(configuration.clientSecret), 'scope': configuration.scope, 'proxyHost': configuration.proxyHost, 'proxyPort': configuration.proxyPort,
                           'proxyUsername': configuration.proxyUsername, 'proxyPassword': configuration.proxyPassword}

        self.access_token = None

    def get_guest_token(self, dashboard_id, filters):
        current_user_principals = Permissions.authenticationToPrincipals(Permissions.getAuthentication())
        username = "','".join(current_user_principals).lower()
        content = {
            "user": {
                "username": username,
                "first_name": "",
                "last_name": ""
            },
            "resources": [
                {
                    "type": "dashboard",
                    "id": dashboard_id
                }
            ],
            "rls": [dict({'clause': filter}) for filter in filters]
        }
        request = HttpRequest(self.connection)
        response = request.post('/metadata/bi/guest_token', self._serialize(content), contentType='application/json')
        if response.status == 200:
            data = self._deserialize(response.response)
            return data['token']
        else:
            self._error(u"Failed to retrieve the guest token", response)

    def list_embeddable_dashboards(self):
        embeddable_dashboards = []
        request = HttpRequest(self.connection)
        response = request.get('/metadata/bi/dashboards?target_app=RELEASE')
        if response.status == 200:
            data = self._deserialize(response.response)
            for dashboard_data in data['results']:
                embeddable_dashboards.append(dashboard_data)
            return embeddable_dashboards
        else:
            self._error(u"Failed to retrieve the list of embeddable dashboards", response)

    def _deserialize(self, text):
        return Json.loads(text)

    def _serialize(self, content):
        return Json.dumps(content)

    def _error(self, text, response=None):
        print u"#### Error: {0} ".format(text)
        if response is not None:
            response.errorDump()
        print
        raise Exception(text)
