import { ClientSettings, HttpConnection } from '../../../../../../../../../core/xlr-ui/app/types';
import { CardSearch } from '../ducks/analytics.reducer';

export enum CardContextMenuItemKey {
    Duplicate = 'duplicate',
    Edit = 'edit',
    Export = 'export',
    Hide = 'hide',
    Share = 'share',
}

export interface AnalyticsCardData {
    contentText: string;
    embeddingId: string;
    embeddingUrl: string;
    externalId: number;
    hasFolderFilter: boolean;
    id: string;
    imageSrc: string;
    subtitle: string;
    tags: string[];
    title: string;
}

export interface IntelligenceHttpConnection extends HttpConnection {
    folderColumnName: string;
}

export interface AnalyticsClientSettings extends ClientSettings {
    setAnalyticsListFilters: (filter: CardSearch | undefined) => void;
}

export interface DashboardListResponse {
    entity: Array<PlatformListDashboardResponse>;
}

type DashboardLifeCycleState = 'DRAFT' | 'PUBLISHED';

interface NativeFilterConfigurationTargetColumn {
    name: string;
}

interface NativeFilterConfigurationTarget {
    column?: NativeFilterConfigurationTargetColumn;
}

export interface NativeFilterConfiguration {
    id: string;
    name: string;
    targets: Array<NativeFilterConfigurationTarget>;
}

export interface PlatformListDashboardResponse {
    created_dt: string;
    dashboard_url: string;
    description: string;
    external_embedding_id: string;
    external_id: string;
    filter_configuration: Array<NativeFilterConfiguration>;
    id: string;
    lifecycle_state: DashboardLifeCycleState;
    name: string;
    server_url: string;
}
