import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { preparePortalContainer, mountComponentWithStore, ReactWrapper } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { AnalyticsPagePortal, AnalyticsPagePortalProps } from './analytics-page.portal';

describe('AnalyticsPagePortal', () => {
    let wrapper: ReactWrapper;

    beforeEach(() => {
        preparePortalContainer();
    });

    const getManageDashboardsButton = () => wrapper.find(DotButton);

    const mount = (props: AnalyticsPagePortalProps) => {
        wrapper = mountComponentWithStore(<AnalyticsPagePortal {...props} />);
    };

    it('should render buttons when analytics is configured', () => {
        mount({ isAnalyticsConfigured: true });
        const buttonManageDashboards = getManageDashboardsButton();
        expect(buttonManageDashboards).toExist();
        expect(buttonManageDashboards).toIncludeText('Manage dashboards');
    });

    it('should not render button when analytics is not configured', () => {
        mount({ isAnalyticsConfigured: false });
        expect(getManageDashboardsButton()).not.toExist();
    });
});
