import { AnalyticsCardData } from '../types';

export const INTELLIGENCE_SERVER_TITLE = 'Digital.ai Analytics';

const imageSrc = 'static/@project.version@/include/analytics-dashboard/assets/test-illustration.svg';

export const ANALYTICS_CATEGORIES: string[] = ['DevOps COE', 'Engineering manager', 'Platform engineer', 'Platform product manager', 'Release manager'];

export const ANALYTICS_AUTHORS: string[] = ['Digital.ai'];

export const ANALYTICS_SAMPLE_CARDS: AnalyticsCardData[] = [
    {
        contentText:
            'Efficiently monitor team and application onboarding and maturation rates on the Digital.ai Release-orchestrated pipeline. Identify areas for improvement.',
        id: '1',
        hasFolderFilter: false,
        embeddingUrl: 'http',
        embeddingId: '1',
        externalId: 1,
        imageSrc,
        subtitle: ANALYTICS_AUTHORS[0],
        tags: [ANALYTICS_CATEGORIES[0]],
        title: 'On-boarding Plan and Progress',
    },
    {
        contentText: 'Leverage DORA metrics for DevOps insights, identify areas for improvement, and drive change in software development.',
        id: '2',
        hasFolderFilter: false,
        embeddingUrl: 'http',
        embeddingId: '2',
        externalId: 2,
        imageSrc,
        subtitle: ANALYTICS_AUTHORS[0],
        tags: [ANALYTICS_CATEGORIES[1]],
        title: 'DORA Overview',
    },
    {
        contentText: 'Retrospective analysis of past release processes over time.',
        id: '3',
        hasFolderFilter: false,
        embeddingUrl: 'http',
        embeddingId: '3',
        externalId: 3,
        imageSrc,
        subtitle: ANALYTICS_AUTHORS[0],
        tags: [ANALYTICS_CATEGORIES[4]],
        title: 'Release Executive Overview',
    },
    {
        contentText:
            'Monitor open tasks, address aged incomplete and dependent tasks. Review upcoming tasks for planning, prioritization, and adjustment for successful releases.',
        id: '4',
        hasFolderFilter: false,
        embeddingUrl: 'http',
        embeddingId: '4',
        externalId: 4,
        imageSrc,
        subtitle: ANALYTICS_AUTHORS[0],
        tags: [ANALYTICS_CATEGORIES[4]],
        title: 'Release Task Open Work Analysis',
    },
    {
        contentText: 'Overview of release delays and dependencies related to Gate tasks.',
        id: '5',
        hasFolderFilter: false,
        embeddingUrl: 'http',
        embeddingId: '5',
        externalId: 5,
        imageSrc,
        subtitle: ANALYTICS_AUTHORS[0],
        tags: [ANALYTICS_CATEGORIES[4]],
        title: 'Release Late Task and Its Impact',
    },
    {
        contentText: 'By revealing the impact of downstream actions on releases, this report empowers release managers to take proactive operational measures.',
        id: '6',
        hasFolderFilter: false,
        embeddingUrl: 'http',
        embeddingId: '6',
        externalId: 6,
        imageSrc,
        subtitle: ANALYTICS_AUTHORS[0],
        tags: [ANALYTICS_CATEGORIES[4]],
        title: 'Release Dependency Dashboard',
    },
    {
        contentText:
            'Gain insights on team adoption of services and automation via Workflows. Identify what works best and manage your developer platform as a product.',
        id: '7',
        hasFolderFilter: false,
        embeddingUrl: 'http',
        embeddingId: '7',
        externalId: 7,
        imageSrc,
        subtitle: ANALYTICS_AUTHORS[0],
        tags: [ANALYTICS_CATEGORIES[2], ANALYTICS_CATEGORIES[3]],
        title: 'Workflow Adoption and Usage Patterns',
    },
];
