package com.xebialabs.xlrelease.analytics.upgrade.db

import com.xebialabs.deployit.security.{PermissionEditor, Role, RoleService}
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.repository.Ids.getName
import com.xebialabs.xlrelease.security.XLReleasePermissions.AUDIT_ALL
import com.xebialabs.xlrelease.security.PermissionChecker.GLOBAL_SECURITY_ALIAS
import com.xebialabs.xlrelease.service.{CiIdService, TeamService}
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging

import scala.util.{Failure, Success, Try}
import scala.jdk.CollectionConverters._

class XLRelease241AnalyticsRoleUpgrade(ciIdService: CiIdService,
                                       roleService: RoleService,
                                       permissionEditor: PermissionEditor)
  extends BaseInitializingUpgrade with Logging {

  private val ANALYTICS_ROLE = "Digital.ai Analytics Service User"


  override def doUpgrade(): Boolean = {
    logger.info(s"Creating global role '$ANALYTICS_ROLE'")
    Try {
      if (!roleService.roleExists(ANALYTICS_ROLE)) {
        val roleToCreate: Role = new Role(ANALYTICS_ROLE)
        roleToCreate.setId(getName(ciIdService.getUniqueId("Role", TeamService.GLOBAL_ROLES_ROOT)))
        roleService.createOrUpdateRole(roleToCreate)
        val permissions = Set(AUDIT_ALL).asJava
        val rolePermissionMap =  Map(roleToCreate -> permissions).asJava
        permissionEditor.editPermissions(GLOBAL_SECURITY_ALIAS, rolePermissionMap)
      } else {
        logger.info(s"Global role '$ANALYTICS_ROLE' already exists")
      }
    } match {
      case Failure(exception) =>
        logger.error(s"Unable to create global role '$ANALYTICS_ROLE'", exception)
      case Success(_) =>
        logger.debug(s"Created global role '$ANALYTICS_ROLE'")
    }
    true
  }

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "24.1.0#7")
  }
