import com.xhaus.jyson.JysonCodec as Json
from com.xebialabs.deployit.util import PasswordEncrypter
from xlrelease.HttpRequest import HttpRequest
from org.springframework.security.core.context import SecurityContextHolder

class SupersetServer:
    def __init__(self, configuration):
        if configuration is None:
            self._error('No Digital.ai Intelligence server connection configured')
        self.connection = {'url': configuration.url, 'proxyHost': configuration.proxyHost, 'proxyPort': configuration.proxyPort,
                           'proxyUsername': configuration.proxyUsername, 'proxyPassword': configuration.proxyPassword,
                           'proxyDomain': configuration.proxyDomain, 'username': configuration.username,
                           'password': PasswordEncrypter.getInstance().ensureDecrypted(configuration.password)}
        self.access_token = None

    def get_access_token(self):
        content = {
            "username": self.connection['username'],
            "password": self.connection['password'],
            "provider": "db",
            "refresh": False
        }

        request = HttpRequest(self.connection, self.connection["username"], self.connection["password"])
        response = request.post('api/v1/security/login', self._serialize(content), contentType='application/json')
        if response.status == 200:
            data = self._deserialize(response.response)
            return data['access_token']
        else:
            self._error("Failed to retrieve access token", response)

    def get_guest_token(self, dashboard_id, filters):
        content = {
            "user": {
                "username": "admin", # hardcoded for now
                "first_name": "",
                "last_name": ""
            },
            "resources": [
                {
                    "type": "dashboard",
                    "id": dashboard_id
                }
            ],
            "rls": [dict({'clause': filter}) for filter in filters]
        }
        request = HttpRequest(self.connection, self.connection["username"], self.connection["password"])
        response = request.post('api/v1/security/guest_token/', self._serialize(content), contentType='application/json', headers=self._createApiHeader())
        if response.status == 200:
            data = self._deserialize(response.response)
            return data['token']
        else:
            self._error(u"Failed to retrieve the guest token for user '{0}'".format(as_user), response)

    def get_dashboard(self, id_or_slug):
        request = HttpRequest(self.connection, self.connection["username"], self.connection["password"])
        headers = self._createApiHeader()
        response = request.get('api/v1/dashboard/{0}'.format(id_or_slug), headers=headers)
        if response.status == 200:
            print response.response
            dashboard = self._deserialize(response.response)['result']
            dashboard_metadata = self._deserialize(dashboard['json_metadata'])
            dashboard['json_metadata'] = dashboard_metadata
            return dashboard
        else:
            self._error(u"Failed to retrieve dashboard information", response)

    def list_embeddable_dashboards(self):
        embeddable_dashboards = []
        query = {
            "columns": ["id", "dashboard_title", "slug", "url", "changed_by_name", "thumbnail_url"],
            "filters": [
                {
                    "col": "published",
                    "opr": "eq",
                    "value": True
                }
            ],
            "keys": [],
            "order_column": "dashboard_title",
            "order_direction": "asc",
            "page": 0,
            "page_size": 1000
        }
        request = HttpRequest(self.connection, self.connection["username"], self.connection["password"])
        headers = self._createApiHeader()
        response = request.get('api/v1/dashboard?q={0}'.format(self._serialize(query)), headers=headers)
        if response.status == 200:
            data = self._deserialize(response.response)
            for dashboard_data in data['result']:
                embeddable_dashboards.append(dashboard_data)
            return embeddable_dashboards
        else:
            self._error(u"Failed to retrieve the list of embeddable dashboards", response)

    def get_embeddable_details(self, dashboard_id):
        request = HttpRequest(self.connection, self.connection["username"], self.connection["password"])
        headers = self._createApiHeader()
        embedded_response = request.get('api/v1/dashboard/{0}/embedded'.format(dashboard_id), headers=headers)
        if embedded_response.status == 200:
            embedded_data = self._deserialize(embedded_response.response)
            if 'result' in embedded_data:
                return embedded_data['result']
            else:
                self._error(u"Failed to retrieve the data for dashboard")
        else:
            self._error(u"Failed to retrieve the data for dashboard", embedded_response)


    def _deserialize(self, text):
        return Json.loads(text)

    def _serialize(self, content):
        return Json.dumps(content)

    def _createApiHeader(self):
        if not self.access_token:
            self.access_token = self.get_access_token()
        header = {u'Authorization': 'Bearer %s' % self.access_token}
        return header

    def _error(self, text, response=None):
        print u"#### Error: {0} ".format(text)
        if response is not None:
            response.errorDump()
        print
        raise Exception(text)
