import React from 'react';
import { DotButton, DotCarousel, DotTypography, DotPill } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import colors from '../../../../../../../../../../core/xlr-ui/app/js/colors';
import { AnalyticsCarouselTile } from './analytics-carousel-tile.component';

describe('AnalyticsCarouselTile component', () => {
    const mount = () => {
        return mountWithTheme(<AnalyticsCarouselTile />);
    };

    const getPremiumPill = (wrapper: ReactWrapper) => wrapper.find(DotPill).at(0);
    const getCarousel = (wrapper: ReactWrapper) => wrapper.find(DotCarousel);
    const getCarouselPage = (wrapper: ReactWrapper, index: number) => wrapper.find('.analytics-carousel-page-container').at(index);
    const getCarouselPageTitle = (wrapper: ReactWrapper, index: number) => getCarouselPage(wrapper, index).find(DotTypography).at(0);
    const getCarouselPageDescription = (wrapper: ReactWrapper, index: number) => getCarouselPage(wrapper, index).find(DotTypography).at(1);
    const getCarouselPageImage = (wrapper: ReactWrapper, index: number) => getCarouselPage(wrapper, index).find('.analytics-carousel-page-content img');
    const getCarouselPageButton = (wrapper: ReactWrapper, index: number) => getCarouselPage(wrapper, index).find(DotButton);

    it('it should render carousel with correct props', () => {
        const wrapper = mount();
        const carouselProps = getCarousel(wrapper).props();
        expect(carouselProps.animation).toBe('slide');
        expect(carouselProps.autoPlay).toBe(true);
        expect(carouselProps.duration).toBe(6);
        expect(carouselProps.backgroundColor).toBe(colors.backgroundBlue);
        expect(carouselProps.className).toBe('analytics-carousel-tile');
        expect(carouselProps.pauseAutoPlayOnHover).toBe(true);
        expect(carouselProps.progressIndicator).toBe(true);
    });

    it('it should render correct page content', () => {
        const wrapper = mount();
        const page = getCarouselPage(wrapper, 0);
        expect(page).toExist();

        const firstPageTitle = getCarouselPageTitle(wrapper, 0);
        expect(firstPageTitle.props().variant).toBe('h2');
        expect(firstPageTitle.props().children).toBe('Release Manager Dashboards');
        expect(getCarouselPageTitle(wrapper, 1).props().children).toBe('DevOps COE Dashboards');
        expect(getCarouselPageTitle(wrapper, 2).props().children).toBe('Workflow Analytics for Platform Teams');
        expect(getCarouselPageTitle(wrapper, 3).props().children).toBe('DORA Analytics');

        expect(getCarouselPageDescription(wrapper, 0).props().children).toBe(
            'Take a proactive approach to release management by swiftly addressing delays and efficiently handling gate tasks and dependencies. Gain valuable insights from an overview down to granular details within the release processes.',
        );
        expect(getCarouselPageDescription(wrapper, 1).props().children).toBe(
            'Efficiently monitor team and application onboarding and maturation rates on the Digital.ai Release-orchestrated pipeline. Identify areas for improvement.',
        );
        expect(getCarouselPageDescription(wrapper, 2).props().children).toBe(
            'Gain insights on team adoption of services and automation via Workflows. Identify what works best and manage your developer platform as a product.',
        );
        expect(getCarouselPageDescription(wrapper, 3).props().children).toBe(
            "Unlock the potential of DORA Analytics to gain insights into your organization's DevOps practices within software development and delivery processes. Discover areas for improvement and drive meaningful change.",
        );

        expect(getCarouselPageImage(wrapper, 0)).toHaveProp('src', 'static/@project.version@/styles/img/follow_the_leader.svg');
        expect(getCarouselPageImage(wrapper, 1)).toHaveProp('src', 'static/@project.version@/styles/img/software_engineer.svg');
        expect(getCarouselPageImage(wrapper, 2)).toHaveProp('src', 'static/@project.version@/styles/img/user_flow.svg');
        expect(getCarouselPageImage(wrapper, 3)).toHaveProp('src', 'static/@project.version@/styles/img/business_analytics.svg');

        const pageButton = getCarouselPageButton(wrapper, 0);
        expect(pageButton.props().type).toBe('primary');
        expect(pageButton.props().children).toBe('View Digital.ai Analytics');

        const pill = getPremiumPill(wrapper);
        expect(pill.props().variant).toBe('outlined');
        expect(pill.props().backgroundcolor).toBe('#cacae4');
        expect(pill.props().bordercolor).toBe('#554a99');
    });
});
