import React from 'react';
import { DotButton, DotCarousel, DotThemeProvider, DotTypography, DotPill, DotIcon, lightColors } from '@digital-ai/dot-components';
import colors from '../../../../../../../../../../core/xlr-ui/app/js/colors';
import './analytics-carousel-tile.component.less';

const followTheLeaderImageLink = 'static/@project.version@/styles/img/follow_the_leader.svg';
const softwareEngineerImageLink = 'static/@project.version@/styles/img/software_engineer.svg';
const userFlowImageLink = 'static/@project.version@/styles/img/user_flow.svg';
const businessAnalyticsImageLink = 'static/@project.version@/styles/img/business_analytics.svg';

type ButtonType = 'destructive' | 'primary' | 'outlined' | 'text';

interface AnalyticsCarouselPageButton {
    buttonCaption: string;
    buttonType: ButtonType;
    onClick: () => void;
}

interface AnalyticsCarouselPage {
    button: AnalyticsCarouselPageButton;
    description: string;
    imageLink: string;
    title: string;
}

export const AnalyticsCarouselTile = () => {
    const analyticsPagesContent: AnalyticsCarouselPage[] = [
        {
            button: {
                buttonCaption: 'View Digital.ai Analytics',
                buttonType: 'primary',
                onClick: () => (window.location.href = '#/analytics'),
            },
            description:
                'Take a proactive approach to release management by swiftly addressing delays and efficiently handling gate tasks and dependencies. Gain valuable insights from an overview down to granular details within the release processes.',
            imageLink: followTheLeaderImageLink,
            title: 'Release Manager Dashboards',
        },
        {
            button: {
                buttonCaption: 'View Digital.ai Analytics',
                buttonType: 'primary',
                onClick: () => (window.location.href = '#/analytics'),
            },
            description:
                'Efficiently monitor team and application onboarding and maturation rates on the Digital.ai Release-orchestrated pipeline. Identify areas for improvement.',
            imageLink: softwareEngineerImageLink,
            title: 'DevOps COE Dashboards',
        },
        {
            button: {
                buttonCaption: 'View Digital.ai Analytics',
                buttonType: 'primary',
                onClick: () => (window.location.href = '#/analytics'),
            },
            description:
                'Gain insights on team adoption of services and automation via Workflows. Identify what works best and manage your developer platform as a product.',
            imageLink: userFlowImageLink,
            title: 'Workflow Analytics for Platform Teams',
        },
        {
            button: {
                buttonCaption: 'View Digital.ai Analytics',
                buttonType: 'primary',
                onClick: () => (window.location.href = '#/analytics'),
            },
            description:
                "Unlock the potential of DORA Analytics to gain insights into your organization's DevOps practices within software development and delivery processes. Discover areas for improvement and drive meaningful change.",
            imageLink: businessAnalyticsImageLink,
            title: 'DORA Analytics',
        },
    ];

    const analyticsPages = analyticsPagesContent.map((page) => {
        return (
            <div className="analytics-carousel-page-container" key={page.title}>
                <div className="analytics-carousel-page-container-title">
                    <DotTypography variant="h2">{page.title}</DotTypography>
                    <DotPill
                        backgroundcolor={lightColors.y50}
                        bordercolor={lightColors.y500}
                        icon={<DotIcon iconId="crown" />}
                        label="Premium"
                        variant="outlined"
                    />
                </div>
                <div className="analytics-carousel-page-content">
                    <div className="analytics-carousel-page-content-wrapper">
                        <DotTypography>{page.description}</DotTypography>
                        <DotButton onClick={page.button.onClick} type={page.button.buttonType}>
                            {page.button.buttonCaption}
                        </DotButton>
                    </div>
                    <img alt="analytics tile image" src={page.imageLink}></img>
                </div>
            </div>
        );
    });

    return (
        <DotThemeProvider>
            <DotCarousel
                animation="slide"
                autoPlay={true}
                backgroundColor={colors.backgroundBlue}
                className="analytics-carousel-tile"
                duration={6}
                pagesContent={analyticsPages}
                pauseAutoPlayOnHover={true}
                progressIndicator={true}
            />
        </DotThemeProvider>
    );
};
