import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { preparePortalContainer, mountComponentWithStore, ReactWrapper } from '../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { AnalyticsPagePortal, AnalyticsPagePortalProps } from './analytics-page.portal';

describe('AnalyticsPagePortal', () => {
    let wrapper: ReactWrapper;

    beforeEach(() => {
        preparePortalContainer();
    });

    const getButton = () => wrapper.find(DotButton);

    const mount = (props: AnalyticsPagePortalProps) => {
        wrapper = mountComponentWithStore(<AnalyticsPagePortal {...props} />);
    };

    it('should render button when analytics is configured', () => {
        mount({ isAnalyticsConfigured: true });
        const button = getButton();
        expect(button).toExist();
        expect(button).toIncludeText('Create dashboard');
    });

    it('should not render button when analytics is not configured', () => {
        mount({ isAnalyticsConfigured: false });
        const button = getButton();
        expect(button).not.toExist();
    });
});
