import com.xhaus.jyson.JysonCodec as Json
from com.xebialabs.deployit.util import PasswordEncrypter
from xlrelease.HttpRequest import HttpRequest

class SupersetServer:
    def __init__(self, configuration):
        if configuration is None:
            self._error('No Digital.ai Intelligence server connection configured')
        self.connection = {'url': configuration.url, 'authenticationMethod': configuration.authenticationMethod,
                           'domain': configuration.domain,
                           'oauth2GrantType': configuration.oauth2GrantType, 'accessTokenUrl': configuration.accessTokenUrl, 'clientId': configuration.clientId,
                           'clientSecret': PasswordEncrypter.getInstance().ensureDecrypted(configuration.clientSecret), 'scope': configuration.scope, 'proxyHost': configuration.proxyHost, 'proxyPort': configuration.proxyPort,
                           'proxyUsername': configuration.proxyUsername, 'proxyPassword': configuration.proxyPassword}

        self.access_token = None

    def get_guest_token(self, dashboard_id, filters):
        content = {
            "user": {
                "username": "admin", # hardcoded for now
                "first_name": "",
                "last_name": ""
            },
            "resources": [
                {
                    "type": "dashboard",
                    "id": dashboard_id
                }
            ],
            "rls": [dict({'clause': filter}) for filter in filters]
        }
        request = HttpRequest(self.connection)
        response = request.post('/metadata/bi/guest_token', self._serialize(content), contentType='application/json')
        if response.status == 200:
            data = self._deserialize(response.response)
            return data['token']
        else:
            self._error(u"Failed to retrieve the guest token", response)

    def list_embeddable_dashboards(self):
        embeddable_dashboards = []
        request = HttpRequest(self.connection)
        response = request.get('/metadata/bi/dashboards?target_app=RELEASE')
        if response.status == 200:
            data = self._deserialize(response.response)
            for dashboard_data in data['results']:
                if 'external_object' in dashboard_data and 'json_metadata' in dashboard_data['external_object']:
                    dashboard_data['external_object']['json_metadata'] = self._deserialize(dashboard_data['external_object']['json_metadata'])
                embeddable_dashboards.append(dashboard_data)
            return embeddable_dashboards
        else:
            self._error(u"Failed to retrieve the list of embeddable dashboards", response)

    def _deserialize(self, text):
        return Json.loads(text)

    def _serialize(self, content):
        return Json.dumps(content)

    def _error(self, text, response=None):
        print u"#### Error: {0} ".format(text)
        if response is not None:
            response.errorDump()
        print
        raise Exception(text)
