/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.xlrelease.activity.ReleaseActivityDateFormatter;
import com.xebialabs.xlrelease.activity.ReleaseActivityUserFormatter;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ReleaseFieldsComparator {
    private Date timestamp;
    private String username;
    private Release original;
    private Release updated;
    private UserInfoResolver userInfoResolver;

    public ReleaseFieldsComparator(Date timestamp, String username, Release original, Release updated, UserInfoResolver userInfoResolver) {
        this.timestamp = timestamp;
        this.username = username;
        this.original = original;
        this.updated = updated;
        this.userInfoResolver = userInfoResolver;
    }

    public List<ActivityLogEntry> getLogs() {
        ArrayList logEntries2 = Lists.newArrayList();
        if (!Objects.equal((Object)this.original.getTitle(), (Object)this.updated.getTitle())) {
            logEntries2.add(ReleaseActivity.RELEASE_TITLE_UPDATED.create(this.timestamp, this.username, this.original.getType(), this.original.getId(), this.original.getTitle(), this.updated.getTitle()));
        }
        if (!Objects.equal((Object)this.original.getDescription(), (Object)this.updated.getDescription())) {
            logEntries2.add(ReleaseActivity.RELEASE_DESCRIPTION_UPDATED.create(this.timestamp, this.username, this.original.getType(), this.original.getId(), this.original.getDescription(), this.updated.getDescription()));
        }
        if (!Objects.equal((Object)this.original.getDueDate(), (Object)this.updated.getDueDate())) {
            logEntries2.add(ReleaseActivity.RELEASE_DUE_DATE_UPDATED.create(this.timestamp, this.username, this.original.getType(), this.original.getId(), ReleaseActivityDateFormatter.formatDate(this.original.getDueDate()), ReleaseActivityDateFormatter.formatDate(this.updated.getDueDate())));
        }
        if (!Objects.equal((Object)this.original.getScheduledStartDate(), (Object)this.updated.getScheduledStartDate())) {
            logEntries2.add(ReleaseActivity.RELEASE_SCHEDULED_START_DATE_UPDATED.create(this.timestamp, this.username, this.original.getType(), this.original.getId(), ReleaseActivityDateFormatter.formatDate(this.original.getScheduledStartDate()), ReleaseActivityDateFormatter.formatDate(this.updated.getScheduledStartDate())));
        }
        if (!Objects.equal((Object)this.original.getOwner(), (Object)this.updated.getOwner())) {
            logEntries2.add(ReleaseActivity.RELEASE_OWNER_UPDATED.create(this.timestamp, this.username, this.original.getType(), this.original.getId(), ReleaseActivityUserFormatter.quoteUser(this.original.getOwner(), this.userInfoResolver), ReleaseActivityUserFormatter.quoteUser(this.updated.getOwner(), this.userInfoResolver)));
        }
        if (!Objects.equal(this.newArrayListOrNull(this.original.getTags()), (Object)this.updated.getTags())) {
            logEntries2.add(ReleaseActivity.RELEASE_TAGS_UPDATED.create(this.timestamp, this.username, this.original.getType(), this.original.getId(), this.updated.getTags() != null ? Sets.newHashSet((Iterable)this.updated.getTags()) : null));
        }
        if (!Objects.equal((Object)this.original.isAbortOnFailure(), (Object)this.updated.isAbortOnFailure())) {
            logEntries2.add(ReleaseActivity.RELEASE_ABORT_RELEASE_ON_FAILURE_UPDATED.create(this.timestamp, this.username, this.original.getType(), this.original.getId(), this.original.isAbortOnFailure(), this.updated.isAbortOnFailure()));
        }
        if (!this.original.isTemplate() && !Objects.equal((Object)this.original.getFlagStatus(), (Object)this.updated.getFlagStatus())) {
            logEntries2.add(ReleaseActivity.RELEASE_FLAG_STATUS_UPDATED.create(this.timestamp, this.username, this.original.getType(), this.original.getId(), this.original.getFlagStatus(), this.updated.getFlagStatus()));
        }
        if (!this.original.isTemplate() && !Objects.equal((Object)this.original.getFlagComment(), (Object)this.updated.getFlagComment())) {
            logEntries2.add(ReleaseActivity.RELEASE_FLAG_COMMENT_UPDATED.create(this.timestamp, this.username, this.original.getType(), this.original.getId(), this.original.getFlagComment(), this.updated.getFlagComment()));
        }
        if (this.original.isTemplate() && !Objects.equal((Object)this.original.isAllowConcurrentReleasesFromTrigger(), (Object)this.updated.isAllowConcurrentReleasesFromTrigger())) {
            logEntries2.add(ReleaseActivity.TEMPLATE_ALLOW_CONCURRENT_RELEASES_FROM_TRIGGER_UPDATED.create(this.timestamp, this.username, this.original.getType(), this.original.getId(), this.original.isAllowConcurrentReleasesFromTrigger(), this.updated.isAllowConcurrentReleasesFromTrigger()));
        }
        if (this.original.hasProperty("riskProfile") && !Objects.equal((Object)this.original.getProperty("riskProfile"), (Object)this.updated.getProperty("riskProfile"))) {
            logEntries2.add(ReleaseActivity.RELEASE_RISK_PROFILE_UPDATED.create(this.timestamp, this.username, this.original.getType(), this.original.getId(), this.getRiskProfileTitle((BaseConfiguration)this.original.getProperty("riskProfile")), this.getRiskProfileTitle((BaseConfiguration)this.updated.getProperty("riskProfile"))));
        }
        return logEntries2;
    }

    private List<String> newArrayListOrNull(List<String> tags) {
        return tags != null ? Lists.newArrayList(tags) : null;
    }

    private String getRiskProfileTitle(BaseConfiguration riskProfile) {
        return null != riskProfile ? riskProfile.getTitle() : "";
    }
}

