/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.ComparisonChain;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(description="Log of something that happened in XL Release.", root=Metadata.ConfigurationItemRoot.APPLICATIONS, versioned=false)
public class ActivityLogEntry
extends BaseConfigurationItem {
    @Property
    private String username;
    @Property
    private String activityType;
    @Property
    private String message;
    @Property
    private Date eventTime;
    @Property
    private String targetType;
    @Property
    private String targetId;
    public static final Comparator<ActivityLogEntry> BY_EVENT_TIME = (left, right) -> ComparisonChain.start().compare((Comparable)left.getEventTime(), (Comparable)right.getEventTime()).result();
    private static final Logger logger = LoggerFactory.getLogger(ActivityLogEntry.class);

    public ActivityLogEntry() {
    }

    public ActivityLogEntry(String activityType, String message) {
        this(new Date(), activityType, null, message, null, null);
    }

    public ActivityLogEntry(Date eventTime, String activityType, String username, String message, String targetType, String targetId) {
        this.eventTime = eventTime;
        this.activityType = activityType;
        this.username = username;
        this.message = message;
        this.targetType = targetType;
        this.targetId = targetId;
    }

    @PublicApiMember
    public boolean hasUsername() {
        return this.username != null;
    }

    @PublicApiMember
    public String getUsername() {
        return this.username;
    }

    @PublicApiMember
    public void setUsername(String username) {
        this.username = username;
    }

    @PublicApiMember
    public String getActivityType() {
        return this.activityType;
    }

    @PublicApiMember
    public void setMessage(String message) {
        this.message = message;
    }

    @PublicApiMember
    public String getMessage() {
        return this.message;
    }

    @PublicApiMember
    public Date getEventTime() {
        return this.eventTime;
    }

    @PublicApiMember
    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    @PublicApiMember
    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    @PublicApiMember
    public String getTargetType() {
        return this.targetType;
    }

    @PublicApiMember
    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    @PublicApiMember
    public String getTargetId() {
        return this.targetId;
    }

    public String toString() {
        return this.message;
    }

    public void logEntryToInfo() {
        HashMap oldMDCContextMap = MDC.getCopyOfContextMap();
        if (oldMDCContextMap == null) {
            oldMDCContextMap = new HashMap();
        }
        try {
            MDC.put((String)"username", (String)this.username);
            MDC.put((String)"activity", (String)this.activityType);
            if (this.targetType != null) {
                MDC.put((String)"targetType", (String)this.targetType);
            }
            if (this.targetId != null) {
                MDC.put((String)"targetId", (String)this.targetId);
            }
            logger.info(this.message);
        }
        finally {
            MDC.setContextMap(oldMDCContextMap);
        }
    }
}

