/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ActivityLogsService;
import com.xebialabs.xlrelease.views.ActivityLogEntryView;
import com.xebialabs.xlrelease.views.LogsFilters;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/releases")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ActivityLogsResource {
    private ActivityLogsService activityLogsService;
    private UserViewConverter userViewConverter;
    private PermissionChecker permissions;

    @Autowired
    public ActivityLogsResource(ActivityLogsService activityLogsService, UserViewConverter userViewConverter, PermissionChecker permissions) {
        this.activityLogsService = activityLogsService;
        this.userViewConverter = userViewConverter;
        this.permissions = permissions;
    }

    @POST
    @Path(value="{releaseId:.*Release[^/-]*}/logs/search")
    public List<ActivityLogEntryView> searchLogs(@PathParam(value="releaseId") @IdParam String releaseId, LogsFilters filters) {
        this.permissions.checkView(releaseId);
        return this.activityLogsService.getFilteredLogs(releaseId, filters).stream().map(this::toActivityLogEntryView).collect(Collectors.toList());
    }

    private ActivityLogEntryView toActivityLogEntryView(ActivityLogEntry activityLogEntry) {
        String username = activityLogEntry.hasUsername() ? activityLogEntry.getUsername() : "SYSTEM";
        UserView user = this.userViewConverter.toUserView(username);
        return new ActivityLogEntryView(user, activityLogEntry.getActivityType(), activityLogEntry.getMessage(), activityLogEntry.getEventTime(), activityLogEntry.getTargetType(), activityLogEntry.getTargetId());
    }
}

