/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plumbing.xltype.serialization.json.CiListJson2Reader;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.repository.ActivityLogRepository;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001\u0017\tY\u0012I]2iSZ,G-Q2uSZLG/\u001f'pON\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u000fM,'O^5dK*\u0011QAB\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0002\u0005\u0002\u0013a,'-[1mC\n\u001c(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011a$\u0011:dQ&4X\rZ!di&4\u0018\u000e^=M_\u001e\u001c8+\u001a:jC2L'0\u001a:\t\u0011]\u0001!\u0011!Q\u0001\na\tQ#Y2uSZLG/\u001f'pOJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\t\u0005Q!/\u001a9pg&$xN]=\n\u0005uQ\"!F!di&4\u0018\u000e^=M_\u001e\u0014V\r]8tSR|'/\u001f\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005\u0001\u0012M]2iSZ,GMU3mK\u0006\u001cXm\u001d\t\u0003C\u0011j\u0011A\t\u0006\u0003G\u0011\t!\u0001\u001a2\n\u0005\u0015\u0012#\u0001E!sG\"Lg/\u001a3SK2,\u0017m]3t\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\u0019\u0011FK\u0016\u0011\u0005M\u0001\u0001\"B\f'\u0001\u0004A\u0002\"B\u0010'\u0001\u0004\u0001\u0003F\u0001\u0014.!\tq\u0013(D\u00010\u0015\t\u0001\u0014'\u0001\u0006b]:|G/\u0019;j_:T!AM\u001a\u0002\u000f\u0019\f7\r^8ss*\u0011A'N\u0001\u0006E\u0016\fgn\u001d\u0006\u0003m]\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002q\u0005\u0019qN]4\n\u0005iz#!C!vi><\u0018N]3e\u0011\u0015a\u0004\u0001\"\u0001>\u0003=9W\r^!di&4\u0018\u000e^=M_\u001e\u001cHC\u0001 M!\ryDIR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0005kRLGNC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0003%\u0001\u0002'jgR\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u0003\u0002\r\u0011|W.Y5o\u0013\tY\u0005J\u0001\tBGRLg/\u001b;z\u0019><WI\u001c;ss\")Qj\u000fa\u0001\u001d\u0006I!/\u001a7fCN,\u0017\n\u001a\t\u0003\u001fZs!\u0001\u0015+\u0011\u0005EsQ\"\u0001*\u000b\u0005MS\u0011A\u0002\u001fs_>$h(\u0003\u0002V\u001d\u00051\u0001K]3eK\u001aL!a\u0016-\u0003\rM#(/\u001b8h\u0015\t)f\u0002\u000b\u0002<5B\u00111,Y\u0007\u00029*\u0011\u0001'\u0018\u0006\u0003=~\u000bq!\\3ue&\u001c7O\u0003\u0002a\u0011\u0005A1m\u001c3bQ\u0006dW-\u0003\u0002c9\n)A+[7fI\")A\r\u0001C\u0005K\u0006)r-\u001a;BGRLg/\u001b;z\u0019><7o\u00149uS>tGC\u00014j!\riqMP\u0005\u0003Q:\u0011aa\u00149uS>t\u0007\"B'd\u0001\u0004q\u0005\"B6\u0001\t\u0003a\u0017AB3ySN$8\u000f\u0006\u0002naB\u0011QB\\\u0005\u0003_:\u0011qAQ8pY\u0016\fg\u000eC\u0003NU\u0002\u0007a\n\u000b\u0002k5\")1\u000f\u0001C!i\u000692/\u001a:jC2L'0Z!di&4\u0018\u000e^=M_\u001e\u001cxJ\u001a\u000b\u0003\u001dVDQ!\u0014:A\u00029C#A\u001d.)\u0005\u0001A\bCA=}\u001b\u0005Q(BA>6\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0003{j\u0014qaU3sm&\u001cW\r")
public class ArchivedActivityLogsService
implements ArchivedActivityLogsSerializer {
    private final ActivityLogRepository activityLogRepository;
    private final ArchivedReleases archivedReleases;

    @Timed
    public List<ActivityLogEntry> getActivityLogs(String releaseId) {
        return (List)this.getActivityLogsOption(releaseId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find activity logs for archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), new Object[0]);
        });
    }

    private Option<List<ActivityLogEntry>> getActivityLogsOption(String releaseId) {
        return this.archivedReleases.getActivityLogs(releaseId, this.archivedReleases.getActivityLogs$default$2()).map((Function1 & Serializable & scala.Serializable)activityLogsJson -> {
            WriteWithoutPasswordCiConverter ciConverter = new WriteWithoutPasswordCiConverter();
            CiListReader ciReader = CiListJson2Reader.create((String)activityLogsJson);
            return ciConverter.readCis(ciReader);
        });
    }

    @Timed
    public boolean exists(String releaseId) {
        return this.archivedReleases.exists(releaseId);
    }

    @Timed
    public String serializeActivityLogsOf(String releaseId) {
        return CiSerializerHelper$.MODULE$.serialize(this.activityLogRepository.findAllLogsOf(releaseId), (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
    }

    @Autowired
    public ArchivedActivityLogsService(ActivityLogRepository activityLogRepository, ArchivedReleases archivedReleases) {
        this.activityLogRepository = activityLogRepository;
        this.archivedReleases = archivedReleases;
    }
}

