/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.xebialabs.xlrelease.activity.DefaultTaskFieldsComparator;
import com.xebialabs.xlrelease.activity.TaskFieldsComparator;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.Task;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationTaskFieldsComparator
implements TaskFieldsComparator<NotificationTask> {
    private DefaultTaskFieldsComparator defaultTaskFieldsComparator;

    @Autowired
    public NotificationTaskFieldsComparator(DefaultTaskFieldsComparator defaultTaskFieldsComparator) {
        this.defaultTaskFieldsComparator = defaultTaskFieldsComparator;
    }

    @Override
    public Class<NotificationTask> getTaskClass() {
        return NotificationTask.class;
    }

    @Override
    public List<ActivityLogEntry> getLogs(NotificationTask original, NotificationTask updated) {
        List<ActivityLogEntry> updateLogs = this.defaultTaskFieldsComparator.getLogs((Task)original, (Task)updated);
        if (!Objects.equal((Object)original.getAddresses(), (Object)updated.getAddresses())) {
            updateLogs.add(ReleaseActivity.TASK_NOTIFICATION_ADDRESSES_UPDATED.create(updated.getTitle(), original.getAddresses() != null ? Sets.newHashSet((Iterable)original.getAddresses()) : null, updated.getAddresses()));
        }
        if (!Objects.equal((Object)original.getSubject(), (Object)updated.getSubject())) {
            updateLogs.add(ReleaseActivity.TASK_NOTIFICATION_SUBJECT_UPDATED.create(updated.getTitle(), original.getSubject(), updated.getSubject()));
        }
        if (!Objects.equal((Object)original.getBody(), (Object)updated.getBody())) {
            updateLogs.add(ReleaseActivity.TASK_NOTIFICATION_BODY_UPDATED.create(updated.getTitle(), original.getBody(), updated.getBody()));
        }
        if (!Objects.equal((Object)original.getCc(), (Object)updated.getCc())) {
            updateLogs.add(ReleaseActivity.TASK_NOTIFICATION_CC_UPDATED.create(updated.getTitle(), original.getCc(), updated.getCc()));
        }
        if (!Objects.equal((Object)original.getBcc(), (Object)updated.getBcc())) {
            updateLogs.add(ReleaseActivity.TASK_NOTIFICATION_BCC_UPDATED.create(updated.getTitle(), original.getBcc(), updated.getBcc()));
        }
        if (!Objects.equal((Object)original.getReplyTo(), (Object)updated.getReplyTo())) {
            updateLogs.add(ReleaseActivity.TASK_NOTIFICATION_REPLY_TO_UPDATED.create(updated.getTitle(), original.getReplyTo(), updated.getReplyTo()));
        }
        if (!Objects.equal((Object)original.getPriority(), (Object)updated.getPriority())) {
            updateLogs.add(ReleaseActivity.TASK_NOTIFICATION_PRIORITY_UPDATED.create(updated.getTitle(), original.getPriority(), updated.getPriority()));
        }
        return updateLogs;
    }
}

