/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.xebialabs.xlrelease.activity.DefaultTaskFieldsComparator;
import com.xebialabs.xlrelease.activity.TaskFieldsComparator;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.Variable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateReleaseTaskFieldsComparator
implements TaskFieldsComparator<CreateReleaseTask> {
    private DefaultTaskFieldsComparator defaultTaskFieldsComparator;

    @Autowired
    public CreateReleaseTaskFieldsComparator(DefaultTaskFieldsComparator defaultTaskFieldsComparator) {
        this.defaultTaskFieldsComparator = defaultTaskFieldsComparator;
    }

    @Override
    public Class<CreateReleaseTask> getTaskClass() {
        return CreateReleaseTask.class;
    }

    @Override
    public List<ActivityLogEntry> getLogs(CreateReleaseTask original, CreateReleaseTask updated) {
        List<ActivityLogEntry> updateLogs = this.defaultTaskFieldsComparator.getLogs((Task)original, (Task)updated);
        if (!com.google.common.base.Objects.equal((Object)original.getNewReleaseTitle(), (Object)updated.getNewReleaseTitle())) {
            updateLogs.add(ReleaseActivity.TASK_RELEASE_TITLE_UPDATED.create(updated.getTitle(), original.getNewReleaseTitle(), updated.getNewReleaseTitle()));
        }
        if (!com.google.common.base.Objects.equal((Object)original.getStartRelease(), (Object)updated.getStartRelease())) {
            updateLogs.add(ReleaseActivity.TASK_START_RELEASE_FLAG_UPDATED.create(updated.getTitle(), original.getStartRelease(), updated.getStartRelease()));
        }
        if (!com.google.common.base.Objects.equal((Object)original.getTemplateId(), (Object)updated.getTemplateId())) {
            updateLogs.add(ReleaseActivity.TASK_RELEASE_TEMPLATE_UPDATED.create(updated.getTitle(), original.getTemplateId(), updated.getTemplateId()));
        } else {
            this.addVariableUpdateLogs(updateLogs, original, updated);
        }
        if (!com.google.common.base.Objects.equal((Object)original.getCreatedReleaseId(), (Object)updated.getCreatedReleaseId())) {
            updateLogs.add(ReleaseActivity.TASK_OUTPUT_PROPERTIES_UPDATED.create("Created release ID", updated.getTitle(), original.getCreatedReleaseId(), updated.getCreatedReleaseId()));
        }
        if (!Objects.equals(original.getReleaseTags(), updated.getReleaseTags()) && !Objects.equals(new HashSet(original.getReleaseTags()), new HashSet(updated.getReleaseTags()))) {
            updateLogs.add(ReleaseActivity.TASK_RELEASE_TAGS_UPDATED.create(updated.getTitle(), original.getReleaseTags(), updated.getReleaseTags()));
        }
        return updateLogs;
    }

    private void addVariableUpdateLogs(List<ActivityLogEntry> updateLogs, CreateReleaseTask original, CreateReleaseTask updated) {
        Stream.concat(original.getTemplateVariables().stream(), updated.getTemplateVariables().stream()).map(Variable::getKey).distinct().forEach(key -> {
            String oldValue = this.getVariableValue(original.getTemplateVariables(), (String)key);
            String newValue = this.getVariableValue(updated.getTemplateVariables(), (String)key);
            boolean isOldPassword = this.isPasswordVariable(original.getTemplateVariables(), (String)key);
            boolean isNewPassword = this.isPasswordVariable(updated.getTemplateVariables(), (String)key);
            if (!com.google.common.base.Objects.equal((Object)oldValue, (Object)newValue)) {
                if (isOldPassword || isNewPassword) {
                    updateLogs.add(ReleaseActivity.TASK_RELEASE_PASSWORD_VARIABLE_UPDATED.create(key, updated.getTitle()));
                } else {
                    updateLogs.add(ReleaseActivity.TASK_RELEASE_VARIABLE_UPDATED.create(key, updated.getTitle(), oldValue, newValue));
                }
            }
        });
    }

    private String getVariableValue(List<Variable> variables, String key) {
        return variables.stream().filter(v -> v.getKey().equals(key)).findFirst().map(Variable::getValueAsString).orElse("");
    }

    private boolean isPasswordVariable(List<Variable> variables, String key) {
        return variables.stream().filter(v -> v.getKey().equals(key)).findFirst().map(Variable::isPassword).orElse(false);
    }
}

