/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.activity.DurationFormatter;
import com.xebialabs.xlrelease.activity.ReleaseActivityDateFormatter;
import com.xebialabs.xlrelease.activity.ReleaseActivityUserFormatter;
import com.xebialabs.xlrelease.activity.TaskFieldsComparator;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultTaskFieldsComparator
implements TaskFieldsComparator<Task> {
    private UserInfoResolver userInfoResolver;

    @Autowired
    public DefaultTaskFieldsComparator(UserInfoResolver userInfoResolver) {
        this.userInfoResolver = userInfoResolver;
    }

    @Override
    public Class<Task> getTaskClass() {
        return Task.class;
    }

    @Override
    public List<ActivityLogEntry> getLogs(Task original, Task updated) {
        ArrayList logEntries = Lists.newArrayList();
        if (!Objects.equal((Object)original.getTitle(), (Object)updated.getTitle())) {
            logEntries.add(ReleaseActivity.TASK_TITLE_UPDATED.create(original.getTitle(), original.getTitle(), updated.getTitle()));
        }
        if (!Objects.equal((Object)original.getDescription(), (Object)updated.getDescription())) {
            logEntries.add(ReleaseActivity.TASK_DESCRIPTION_UPDATED.create(updated.getTitle(), original.getDescription(), updated.getDescription()));
        }
        if (!Objects.equal((Object)original.getOwner(), (Object)updated.getOwner())) {
            logEntries.add(ReleaseActivity.TASK_OWNER_UPDATED.create(updated.getTitle(), ReleaseActivityUserFormatter.quoteUser(original.getOwner(), this.userInfoResolver), ReleaseActivityUserFormatter.quoteUser(updated.getOwner(), this.userInfoResolver)));
        }
        if (!Objects.equal((Object)original.getTeam(), (Object)updated.getTeam())) {
            logEntries.add(ReleaseActivity.TASK_TASK_TEAM_UPDATED.create(updated.getTitle(), ReleaseActivityUserFormatter.quoteAssignee(original.getTeam()), ReleaseActivityUserFormatter.quoteAssignee(updated.getTeam())));
        }
        if (!Objects.equal((Object)original.getDueDate(), (Object)updated.getDueDate())) {
            logEntries.add(ReleaseActivity.TASK_DUE_DATE_UPDATED.create(updated.getTitle(), ReleaseActivityDateFormatter.formatDate(original.getDueDate()), ReleaseActivityDateFormatter.formatDate(updated.getDueDate())));
        }
        if (!Objects.equal((Object)original.getScheduledStartDate(), (Object)updated.getScheduledStartDate())) {
            logEntries.add(ReleaseActivity.TASK_SCHEDULED_START_DATE_UPDATED.create(updated.getTitle(), ReleaseActivityDateFormatter.formatDate(original.getScheduledStartDate()), ReleaseActivityDateFormatter.formatDate(updated.getScheduledStartDate())));
        }
        if (!Objects.equal((Object)original.isWaitForScheduledStartDate(), (Object)updated.isWaitForScheduledStartDate())) {
            logEntries.add(ReleaseActivity.TASK_WAIT_FOR_SCHEDULED_START_DATE_UPDATED.create(updated.getTitle(), updated.isWaitForScheduledStartDate()));
        }
        if (!Objects.equal((Object)original.getFlagStatus(), (Object)updated.getFlagStatus())) {
            logEntries.add(ReleaseActivity.TASK_FLAG_STATUS_UPDATED.create(updated.getTitle(), original.getFlagStatus().name(), updated.getFlagStatus().name()));
        }
        if (!Objects.equal((Object)original.getFlagComment(), (Object)updated.getFlagComment())) {
            logEntries.add(ReleaseActivity.TASK_FLAG_COMMENT_UPDATED.create(updated.getTitle(), original.getFlagComment(), updated.getFlagComment()));
        }
        if (!Objects.equal((Object)original.getPlannedDuration(), (Object)updated.getPlannedDuration())) {
            logEntries.add(ReleaseActivity.TASK_DURATION_UPDATED.create(updated.getTitle(), DurationFormatter.formatDuration(original.getPlannedDuration()), DurationFormatter.formatDuration(updated.getPlannedDuration())));
        }
        if (!Objects.equal((Object)original.getPrecondition(), (Object)updated.getPrecondition())) {
            logEntries.add(ReleaseActivity.TASK_PRECONDITION_UPDATED.create(updated.getTitle(), original.getPrecondition(), updated.getPrecondition()));
        }
        return logEntries;
    }
}

