/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.repository.ActivityLogs;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.CiListJsonReader;
import java.io.Serializable;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u0017\tY\u0012I]2iSZ,G-Q2uSZLG/\u001f'pON\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u000fM,'O^5dK*\u0011QAB\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0002\u0005\u0002\u0013a,'-[1mC\n\u001c(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011a$\u0011:dQ&4X\rZ!di&4\u0018\u000e^=M_\u001e\u001c8+\u001a:jC2L'0\u001a:\t\u0011]\u0001!\u0011!Q\u0001\na\tA\"Y2uSZLG/\u001f'pON\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0003\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002\u001e5\ta\u0011i\u0019;jm&$\u0018\u0010T8hg\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\tbe\u000eD\u0017N^3e%\u0016dW-Y:fgB\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005B\u0001\u0003I\nL!!\n\u0012\u0003!\u0005\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\b\"B\u0014\u0001\t\u0003A\u0013A\u0002\u001fj]&$h\bF\u0002*U-\u0002\"a\u0005\u0001\t\u000b]1\u0003\u0019\u0001\r\t\u000b}1\u0003\u0019\u0001\u0011)\u0005\u0019j\u0003C\u0001\u0018:\u001b\u0005y#B\u0001\u00192\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003eM\nqAZ1di>\u0014\u0018P\u0003\u00025k\u0005)!-Z1og*\u0011agN\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001(A\u0002pe\u001eL!AO\u0018\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"\u0002\u001f\u0001\t\u0003i\u0014aD4fi\u0006\u001bG/\u001b<jifdunZ:\u0015\u0005yb\u0005cA E\r6\t\u0001I\u0003\u0002B\u0005\u0006!Q\u000f^5m\u0015\u0005\u0019\u0015\u0001\u00026bm\u0006L!!\u0012!\u0003\t1K7\u000f\u001e\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013\u0012\ta\u0001Z8nC&t\u0017BA&I\u0005A\t5\r^5wSRLHj\\4F]R\u0014\u0018\u0010C\u0003Nw\u0001\u0007a*A\u0005sK2,\u0017m]3JIB\u0011qJ\u0016\b\u0003!R\u0003\"!\u0015\b\u000e\u0003IS!a\u0015\u0006\u0002\rq\u0012xn\u001c;?\u0013\t)f\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003/b\u0013aa\u0015;sS:<'BA+\u000f\u0011\u0015Q\u0006\u0001\"\u0003\\\u0003U9W\r^!di&4\u0018\u000e^=M_\u001e\u001cx\n\u001d;j_:$\"\u0001X0\u0011\u00075if(\u0003\u0002_\u001d\t1q\n\u001d;j_:DQ!T-A\u00029CQ!\u0019\u0001\u0005\u0002\t\fa!\u001a=jgR\u001cHCA2g!\tiA-\u0003\u0002f\u001d\t9!i\\8mK\u0006t\u0007\"B'a\u0001\u0004q\u0005\"\u00025\u0001\t\u0003J\u0017aF:fe&\fG.\u001b>f\u0003\u000e$\u0018N^5us2{wm](g)\tq%\u000eC\u0003NO\u0002\u0007a\n\u000b\u0002\u0001YB\u0011Q\u000e]\u0007\u0002]*\u0011q.N\u0001\u000bgR,'/Z8usB,\u0017BA9o\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class ArchivedActivityLogsService
implements ArchivedActivityLogsSerializer {
    private final ActivityLogs activityLogs;
    private final ArchivedReleases archivedReleases;

    public List<ActivityLogEntry> getActivityLogs(String releaseId) {
        return (List)this.getActivityLogsOption(releaseId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find activity logs for archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), new Object[0]);
        });
    }

    private Option<List<ActivityLogEntry>> getActivityLogsOption(String releaseId) {
        return this.archivedReleases.getActivityLogs(releaseId).map((Function1 & Serializable & scala.Serializable)activityLogsJson -> {
            WriteWithoutPasswordCiConverter ciConverter = new WriteWithoutPasswordCiConverter();
            CiListJsonReader ciReader = new CiListJsonReader(new JSONArray(activityLogsJson));
            return ciConverter.readCis((CiListReader)ciReader);
        });
    }

    public boolean exists(String releaseId) {
        return this.archivedReleases.exists(releaseId);
    }

    public String serializeActivityLogsOf(String releaseId) {
        return CiSerializerHelper$.MODULE$.serialize(this.activityLogs.findAllLogsOf(releaseId), (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
    }

    @Autowired
    public ArchivedActivityLogsService(ActivityLogs activityLogs, ArchivedReleases archivedReleases) {
        this.activityLogs = activityLogs;
        this.archivedReleases = archivedReleases;
    }
}

