package com.xebialabs.xlrelease.activity;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.GateTask;

import java.util.Date;
import java.util.List;

import static com.google.common.base.Objects.equal;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.GATE_FAIL_DEPENDENCY_FLAG_UPDATED;

@Component
public class GateTaskFieldsComparator implements TaskFieldsComparator<GateTask> {

    private DefaultTaskFieldsComparator defaultTaskFieldsComparator;

    @Autowired
    public GateTaskFieldsComparator(final DefaultTaskFieldsComparator defaultTaskFieldsComparator) {
        this.defaultTaskFieldsComparator = defaultTaskFieldsComparator;
    }

    @Override
    public Class<GateTask> getTaskClass() {
        return GateTask.class;
    }

    @Override
    public List<ActivityLogEntry> getLogs(Date timestamp, String username, final GateTask original, final GateTask updated) {
        List<ActivityLogEntry> updateLogs = defaultTaskFieldsComparator.getLogs(timestamp, username, original, updated);

        if (!equal(original.isTransitionToFailed(), updated.isTransitionToFailed())) {
            updateLogs.add(GATE_FAIL_DEPENDENCY_FLAG_UPDATED.create(timestamp, username, original.getTaskType(), original.getId(),
                    updated.getTitle(), original.isTransitionToFailed(), updated.isTransitionToFailed())
            );
        }

        return updateLogs;
    }
}
