import { drawerHistory, initialState } from './drawer-history.reducer';
import { DEFAULT_FILTER_SETTINGS } from '../../../constants';
import { ActivityLog } from '../../../types';

describe('drawerHistory reducer', () => {
    const { init, setIsLoading, loadFilteredAndPagedHistoryLogs, setLogsFilter, setLogs, setPage, setIsLastPage, reset } = drawerHistory.actions;

    const activityLogSample: ActivityLog = {
        user: {
            username: 'admin',
            fullName: 'Release Administrator',
            email: 'releaseadmin@dai.com',
        },
        activityType: 'RELEASE_CREATED',
        message: 'Created the release',
        eventTime: 1726472112657,
        targetType: 'time.Schedule',
        targetId: 'Applications/Folder1/Release1',
        dataId: null,
    };

    it('should have the initial state', () => {
        expect(drawerHistory.name).toBe('drawerHistory');
        expect(drawerHistory.reducer(undefined, { type: 'default' })).toBe(initialState);
        expect(Object.keys(drawerHistory.actions)).toStrictEqual([
            'init',
            'loadFilteredAndPagedHistoryLogs',
            'reset',
            'setLogsFilter',
            'setIsLoading',
            'setLogs',
            'setPage',
            'setIsLastPage',
        ]);
    });

    describe('reducers', () => {
        describe('init', () => {
            it('should NOT update state', () => {
                const state = drawerHistory.reducer(initialState, init({ containerId: '123', taskId: 'Task123', filterSettings: DEFAULT_FILTER_SETTINGS }));
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('loadFilteredAndPagedHistoryLogs', () => {
            it('should NOT update state', () => {
                const state = drawerHistory.reducer(
                    initialState,
                    loadFilteredAndPagedHistoryLogs({
                        logsFilter: { containerId: '123', taskId: 'Task123', filterSettings: DEFAULT_FILTER_SETTINGS },
                        page: 1,
                    }),
                );
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('reset', () => {
            it('should update state', () => {
                const state = drawerHistory.reducer(initialState, reset());
                expect(state).toStrictEqual(initialState);
            });
        });

        describe('loadFilteredAndPagedHistoryLogs', () => {
            it('should update the state ', () => {
                const containerId = '123';
                const taskId = 'Task123';
                const filterSettings = {
                    ...DEFAULT_FILTER_SETTINGS,
                    targetId: 'targetId',
                };
                const state = drawerHistory.reducer(initialState, setLogsFilter({ containerId, taskId, filterSettings }));
                expect(state).toStrictEqual({
                    ...initialState,
                    logsFilter: { containerId, taskId, filterSettings },
                });
            });
        });

        describe('setIsLoading', () => {
            it('should update state', () => {
                const state = drawerHistory.reducer(initialState, setIsLoading(true));
                expect(state.isLoading).toStrictEqual(true);
            });
        });

        describe('setLogs', () => {
            it('should update state', () => {
                const state = drawerHistory.reducer(initialState, setLogs([activityLogSample]));
                expect(state.logs).toStrictEqual([activityLogSample]);
            });
        });

        describe('setPage', () => {
            it('should update state', () => {
                const state = drawerHistory.reducer(initialState, setPage(3));
                expect(state.page).toBe(3);
            });
        });

        describe('setIsLastPage', () => {
            it('should update state', () => {
                const state = drawerHistory.reducer(initialState, setIsLastPage(true));
                expect(state.isLastPage).toBe(true);
            });
        });
    });
});
