package com.xebialabs.xlrelease.activity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.ReleaseActivity;

import static com.google.common.base.Objects.equal;
import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.GATE_CONDITION_FULFILLED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.GATE_CONDITION_TITLE_UPDATED;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.GATE_CONDITION_UNFULFILLED;

public class GateConditionsFieldsComparator {

    private Date timestamp;

    private String username;

    private GateCondition original;

    private GateCondition updated;

    private String gateTaskTitle;

    public GateConditionsFieldsComparator(Date timestamp, String username, String gateTaskTitle, GateCondition original, GateCondition updated) {
        this.timestamp = timestamp;
        this.username = username;
        this.original = original;
        this.updated = updated;
        this.gateTaskTitle = gateTaskTitle;
    }

    public List<ActivityLogEntry> getLogs() {
        ArrayList<ActivityLogEntry> logEntries = newArrayList();

        if (!equal(original.getTitle(), updated.getTitle())) {
            logEntries.add(GATE_CONDITION_TITLE_UPDATED.create(timestamp, username, original.getType(), original.getId(),
                    gateTaskTitle, original.getTitle(), updated.getTitle())
            );
        }

        if (!equal(original.isChecked(), updated.isChecked())) {
            ReleaseActivity activity = updated.isChecked() ? GATE_CONDITION_FULFILLED : GATE_CONDITION_UNFULFILLED;
            logEntries.add(activity.create(timestamp, username, original.getType(), original.getId(), gateTaskTitle, updated.getTitle()));
        }

        return logEntries;
    }
}
