package com.xebialabs.xlrelease.service

import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util
import java.util.Optional
import scala.jdk.CollectionConverters._

@Service
class ExecutionDataFindService @Autowired()(maybeFinders: Optional[java.util.List[ExecutionDataFinder]]) {
  private lazy val finders = maybeFinders.orElse(util.Collections.emptyList[ExecutionDataFinder]).asScala

  private def findImplementation(dataId: CiId) = {
    finders.find(_.supports(dataId))
      .getOrElse(throw new IllegalArgumentException(s"Unsupported data type for $dataId"))
  }

  def getExecutionData(dataId: CiId): String = {
    findImplementation(dataId).find(dataId).orNull
  }
}
