package com.xebialabs.xlrelease.activity

import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.Subscribe
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class ActivityLogsMovingEventHandler @Autowired()(activityLogRepository: ActivityLogRepository) extends Logging {
  @Subscribe
  def onReleaseMovedEvent(event: ReleaseMovedEvent): Unit = {
    activityLogRepository.move(event.fromReleaseId, event.toReleaseId)
  }

}
