import React, { RefObject } from 'react';
import { DotSkeleton } from '@digital-ai/dot-components';
import './drawer-history-skeleton-row.component.less';

export interface DrawerHistorySkeletonRowProps {
    observerTarget?: RefObject<HTMLDivElement>;
}

export const DrawerHistorySkeletonRow = ({ observerTarget }: DrawerHistorySkeletonRowProps) => {
    return (
        <div className="drawer-history-skeleton-row" ref={observerTarget}>
            <div className="skeleton-row-left">
                <DotSkeleton data-testid="avatar-skeleton" height={24} variant="circular" width={24} />
            </div>
            <div className="skeleton-row-right">
                <div className="skeleton-row-right-header">
                    <DotSkeleton data-testid="header-user-skeleton" variant="text" width={120} />
                    <DotSkeleton data-testid="header-time-skeleton" variant="text" width={60} />
                </div>
                <div>
                    {[...Array(3)].map((_, index: number) => (
                        <DotSkeleton data-testid={`row-data-skeleton-${index}`} key={index} variant="text" />
                    ))}
                </div>
            </div>
        </div>
    );
};
