package com.xebialabs.xlrelease.activity;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import com.google.common.base.Joiner;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.ActivityCategory;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;

public interface ActivityOps {

    default ActivityLogEntry create(Date eventTime, String activityType, String username, Type targetType, String targetId, String message, Object... parameters) {
        return new ActivityLogEntry(eventTime, activityType, username, format(message, formatParameters(parameters)), targetType.toString(), targetId);
    }

    default String format(String message, Object... parameters) {
        return String.format(message, parameters);
    }

    default Object[] formatParameters(Object[] parameters) {
        for (int i = 0; i < parameters.length; i++) {
            if (parameters[i] == null) {
                parameters[i] = "";
            } else if (parameters[i] instanceof Iterable<?>) {
                parameters[i] = String.format("[%s]", Joiner.on(", ").join((Iterable<?>) parameters[i]));
            } else if (parameters[i] instanceof Map<?, ?>) {
                parameters[i] = String.format("{%s}", Joiner.on(", ").join(((Map<?, ?>) parameters[i]).entrySet()));
            }
        }
        return parameters;
    }

    String getName();
    Set<ActivityCategory> getCategories();

}
