import React from 'react';
import { DotDialog, DotSkeleton, DotTypography } from '@digital-ai/dot-components';
import './activity-logs-event-dialog.component.less';

export interface ActivityLogsEventDialogProps {
    content?: string;
    onClose: () => void;
}

export const ActivityLogsEventDialog = ({ content, onClose }: ActivityLogsEventDialogProps) => {
    const renderSkeleton = () => {
        return [...Array(3)].map((_, index: number) => <DotSkeleton height="36px" key={index} variant="rectangular" width="100%" />);
    };

    return (
        <DotDialog
            cancelButtonVisible={false}
            className="activity-logs-event-dialog"
            closeIconVisible={true}
            onCancel={onClose}
            onSubmit={onClose}
            open={true}
            submitButtonProps={{ label: 'Close' }}
            title="Event details"
        >
            <>
                <DotTypography variant="body1">The HTTP request that attempted to execute the trigger:</DotTypography>
                {content ? <pre>{content}</pre> : renderSkeleton()}
            </>
        </DotDialog>
    );
};
