package com.xebialabs.xlrelease.activity

import com.xebialabs.xlrelease.domain.ReleaseActivity._
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe, XLReleaseEventBus}
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import com.xebialabs.xlrelease.service.TaskService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@EventListener
class GateConditionActivityLoggingEventHandler @Autowired()(val eventBus: XLReleaseEventBus,
                                                            val activityLogRepository: ActivityLogRepository,
                                                            taskService: TaskService)
  extends ActivityLogger[GateConditionEvent] {

  @Subscribe
  def onEvent(event: GateConditionEvent): Unit = log(event)

  override def logEntries = {
    case ev@GateConditionCreatedEvent(task, gateCondition) =>
      LoggingParams(releaseIdFrom(task), None,
        List(GATE_CONDITION_CREATED.create(ev, ev.gateCondition, taskService.getTitle(task.getId), gateCondition.getTitle))
      )

    case ev: GateConditionUpdatedEvent =>
      val entries = new GateConditionsFieldsComparator(ev.timestamp, ev.username, taskService.getTitle(ev.task.getId), ev.original, ev.updated)
        .getLogs.asScala.toList
      LoggingParams(releaseIdFrom(ev.task), Option(ev.username), entries)

    case ev@GateConditionDeletedEvent(task, gateCondition) =>
      LoggingParams(releaseIdFrom(task), None,
        List(GATE_CONDITION_DELETED.create(ev, ev.gateCondition, taskService.getTitle(task.getId), gateCondition.getTitle))
      )
  }
}
