package com.xebialabs.xlrelease.activity

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.repository.{ActivityLogRepository, PersistenceInterceptor, ReleaseRepository}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class ActivityLogPersistenceInterceptor @Autowired()(releaseRepository: ReleaseRepository, activityLogRepository: ActivityLogRepository)
  extends PersistenceInterceptor[Release] {

  releaseRepository.registerPersistenceInterceptor(this)

  override def onDelete(ciId: String): Unit = {
    activityLogRepository.delete(ciId)
  }

}
