package com.xebialabs.xlrelease.activity;

import java.util.Date;
import java.util.List;
import com.google.common.base.Joiner;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Team;

import static com.google.common.base.Joiner.MapJoiner;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.PERMISSIONS_UPDATED;

public class PermissionsLogFormatter {

    private Date timestamp;

    private String username;

    private Type targetType;

    private String targetId;

    private Multimap<String, String> teamToPermissions = TreeMultimap.create();

    private static final MapJoiner WITH_ARROWS = Joiner.on("\n").withKeyValueSeparator(" => ");

    public PermissionsLogFormatter(Date timestamp, String username, Type targetType, String targetId, List<Team> teams) {
        this.timestamp = timestamp;
        this.username = username;
        this.targetType = targetType;
        this.targetId = targetId;
        for (Team team : teams) {
            teamToPermissions.putAll(team.getTeamName(), team.getPermissions());
        }
    }

    public ActivityLogEntry getLogEntry() {
        String text = WITH_ARROWS.join(teamToPermissions.asMap().entrySet());
        return PERMISSIONS_UPDATED.create(timestamp, username, targetType, targetId, text);
    }
}
