import React from 'react';
import { DotPill } from '@digital-ai/dot-components';
import { act, mountWithTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { ExpandableTypography } from '@xlr-ui/app/features/common/components/expandable-typography/expandable-typography.component';
import { ActivityLogsActivity, ActivityLogsActivityProps } from './activity-logs-activity.component';
import { calculateActivityLogColumnProps } from '../../helper';
import { TextAreaMarkdown } from '@xlr-ui/app/react/components/markdown/textarea-markdown.component';

describe('ActivityLogsActivity component', () => {
    let wrapper: ReactWrapper;
    const activityType = 'TASK_COMPLETED';
    const message = 'my test message';
    const eventTime = 1;
    const activityLogColumnProps = calculateActivityLogColumnProps(activityType, message);

    const defaultProps: ActivityLogsActivityProps = {
        activityType,
        eventTime,
        message,
    };

    const getExpandableTypography = () => wrapper.find(ExpandableTypography);
    const getMarkdown = () => wrapper.find(TextAreaMarkdown);
    const getDotPill = () => wrapper.find(DotPill);

    const mount = async (props: ActivityLogsActivityProps = defaultProps) => {
        await act(async () => {
            wrapper = mountWithTheme(<ActivityLogsActivity {...props} />);
        });
    };

    it('should render properly', async () => {
        await mount();

        const dotPill = getDotPill();
        expect(dotPill).toExist();
        const dotPillProps = dotPill.props();
        expect(dotPillProps.backgroundcolor).toBe(activityLogColumnProps?.background);
        expect(dotPillProps.bordercolor).toBe(activityLogColumnProps?.border);
        expect(dotPillProps.label).toBe(activityLogColumnProps?.label);
        expect(dotPillProps.size).toBe('small');
        expect(dotPillProps.variant).toBe('outlined');

        const expandableTypography = getExpandableTypography();
        expect(expandableTypography).toExist();
        const expandableTypographyProps = expandableTypography.props();
        expect(expandableTypographyProps.text).toBe(message);
    });

    it('should NOT render pill for specific activity types', async () => {
        await mount({ ...defaultProps, activityType: 'PHASE_RESTARTED' });
        const dotPill = getDotPill();
        expect(dotPill).not.toExist();
    });

    it('should render message as markdown', async () => {
        await mount({ ...defaultProps, message: 'see link [release](#/releases/Release1)', activityType: 'TRIGGER_EXECUTED' });
        const markdownProps = getMarkdown().props();
        expect(markdownProps.inputId).toBe('TRIGGER_EXECUTED-1');
        expect(markdownProps.isReadOnly).toBe(true);
        expect(markdownProps.name).toBe('activity-message');
        expect(markdownProps.rows).toBe(1);
        expect(markdownProps.text).toBe('see link [release](#/releases/Release1)');
    });
});
