import React from 'react';
import { mockResizeObserver, mountWithTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { AvatarWithName } from '@xlr-ui/app/features/tasks/components/common/avatar-with-name.component';
import { User } from '@xlr-ui/app/types';
import { ActivityLogsUser, ActivityLogsUserProps } from './activity-logs-user.component';
import { getActivityLogUserTitle } from '../helper';

describe('ActivityLogsUser component', () => {
    let wrapper: ReactWrapper;
    const user: User = {
        username: 'admin',
        fullName: 'Test Admin',
    };
    const defaultTitle = getActivityLogUserTitle(user);

    const defaultProps: ActivityLogsUserProps = {
        user,
        title: defaultTitle,
    };

    const getAvatarWithName = () => wrapper.find(AvatarWithName);

    const mount = (props: ActivityLogsUserProps = defaultProps) => {
        wrapper = mountWithTheme(<ActivityLogsUser {...props} />);
    };

    beforeEach(() => {
        mockResizeObserver();
    });

    it('should render properly', () => {
        mount();
        const avatarWithName = getAvatarWithName();
        expect(avatarWithName).toExist();
        const avatarWithNameProps = avatarWithName.props();
        expect(avatarWithNameProps.avatarImgSrc).toBe(undefined);
        expect(avatarWithNameProps.id).toBe(user.username);
        expect(avatarWithNameProps.title).toBe(user.fullName);
    });

    it('should render with correct props for system user', () => {
        mount({ ...defaultProps, user: { ...user, username: 'TASK COMMENT' } });
        const avatarWithName = getAvatarWithName();
        expect(avatarWithName).toExist();
        const avatarWithNameProps = avatarWithName.props();
        expect(avatarWithNameProps.avatarImgSrc).toBe('static/@project.version@/styles/img/release-icon.svg');
        expect(avatarWithNameProps.id).toBe(`TASK COMMENT`);
        expect(avatarWithNameProps.title).toBe(defaultTitle);
    });
});
