package com.xebialabs.xlrelease.api.v1.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Controller;

import com.xebialabs.xlrelease.api.v1.ActivityLogsApi;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.handler.BaseActivityLogsApiHandler;
import com.xebialabs.xlrelease.repository.Ids;

import io.micrometer.core.annotation.Timed;

import static java.lang.String.format;

@Controller
public class ActivityLogsApiImpl implements ActivityLogsApi {

    private static Map<String, BaseActivityLogsApiHandler> apiHandlerMap = new HashMap<>();

    @Timed
    public List<ActivityLogEntry> getActivityLogs(String containerId) {
        if (Ids.isReleaseId(containerId)) {
            return getActivityLogs("release", containerId);
        } else if (Ids.isTaskId(containerId)) {
            return getActivityLogs("task", containerId);
        } else if (Ids.isDeliveryId(containerId)) {
            return getActivityLogs("delivery", containerId);
        } else if (Ids.isTriggerId(containerId)) {
            return getActivityLogs("trigger", containerId);
        } else {
            throw new IllegalArgumentException(String.format("Could not get activity logs for '%s'", containerId));
        }
    }

    public static void registerApiHandler(String handlerName, BaseActivityLogsApiHandler baseActivityLogsApiHandler) {
        apiHandlerMap.put(handlerName, baseActivityLogsApiHandler);
    }

    private List<ActivityLogEntry> getActivityLogs(String handlerName, String containerId) {
        if (apiHandlerMap.containsKey(handlerName)) {
            return apiHandlerMap.get(handlerName).getActivityLogs(containerId);
        } else {
            throw new IllegalStateException(format("No API handler registered to get %s activity logs.", handlerName));
        }
    }
}
