package com.xebialabs.xlrelease.activity;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.variables.Variable;

import static com.google.common.base.Objects.equal;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_INPUT_VARIABLES_UPDATED;

@Component
public class UserInputTaskFieldsComparator implements TaskFieldsComparator<UserInputTask> {

    private DefaultTaskFieldsComparator defaultTaskFieldsComparator;

    @Autowired
    public UserInputTaskFieldsComparator(final DefaultTaskFieldsComparator defaultTaskFieldsComparator) {
        this.defaultTaskFieldsComparator = defaultTaskFieldsComparator;
    }

    @Override
    public Class<UserInputTask> getTaskClass() {
        return UserInputTask.class;
    }

    @Override
    public List<ActivityLogEntry> getLogs(Date timestamp, String username, final UserInputTask original, final UserInputTask updated) {
        List<ActivityLogEntry> updateLogs = defaultTaskFieldsComparator.getLogs(timestamp, username, original, updated);

        List<String> originalKeys = Optional.of(original.getVariables()).map(variables -> variables.stream().map(Variable::getKey)).orElse(Stream.empty()).toList();
        List<String> updatedKeys = Optional.of(updated.getVariables()).map(variables -> variables.stream().map(Variable::getKey)).orElse(Stream.empty()).toList();
        if (!equal(originalKeys, updatedKeys)) {
            updateLogs.add(TASK_INPUT_VARIABLES_UPDATED.create(
                    timestamp,
                    username,
                    original.getTaskType(),
                    original.getId(),
                    updated.getTitle(),
                    originalKeys,
                    updatedKeys)
            );
        }

        return updateLogs;
    }
}
