/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.service.BaseActivityLogsService;
import com.xebialabs.xlrelease.views.ActivityLogEntryView;
import com.xebialabs.xlrelease.views.LogsFilters;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;

public abstract class BaseActivityLogsResource {
    private BaseActivityLogsService baseActivityLogsService;
    private UserViewConverter userViewConverter;

    public BaseActivityLogsResource(BaseActivityLogsService baseActivityLogsService, UserViewConverter userViewConverter) {
        this.baseActivityLogsService = baseActivityLogsService;
        this.userViewConverter = userViewConverter;
    }

    protected List<ActivityLogEntryView> searchLogs(String containerId, LogsFilters filters, Pageable pageable) {
        return this.baseActivityLogsService.getFilteredLogs(containerId, filters, pageable).stream().map(this::toActivityLogEntryView).collect(Collectors.toList());
    }

    protected ActivityLogEntryView toActivityLogEntryView(ActivityLogEntry activityLogEntry) {
        String username = activityLogEntry.hasUsername() ? activityLogEntry.getUsername() : "SYSTEM";
        UserView user = this.userViewConverter.toUserView(username);
        return new ActivityLogEntryView(user, activityLogEntry.getActivityType(), activityLogEntry.getMessage(), activityLogEntry.getEventTime(), activityLogEntry.getTargetType(), activityLogEntry.getTargetId(), activityLogEntry.getDataId());
    }

    protected List<UserView> getUniqueUsers(String containerId) {
        return this.baseActivityLogsService.getUniqueUsers(containerId).stream().map(arg_0 -> ((UserViewConverter)this.userViewConverter).toUserView(arg_0)).collect(Collectors.toList());
    }

    protected List<String> getUniqueActivityTypes(String containerId) {
        return this.baseActivityLogsService.getUniqueActivityTypes(containerId);
    }
}

