import moment from 'moment';
import groupBy from 'lodash/groupBy';
import { ActivityLog, ActivityLogGroupType, ActivityLogsFilterSettings } from '../types';
import { LogsFilter } from '../features/activity-logs/ducks/activity-logs.reducer';
import { HistoryLogsFilter } from '../features/drawer-history/ducks/drawer-history.reducer';
import { LOG_USER, SYSTEM_USER, SYSTEM_USERS } from '../constants';
import { User } from '@xlr-ui/app/types';

export const getFilterSettingsForLoadPayload = (
    filterSettings: ActivityLogsFilterSettings,
): Omit<ActivityLogsFilterSettings, 'isImportantHighlighted' | 'folderId'> => {
    const { isImportantHighlighted, folderId, ...rest } = filterSettings;
    return rest;
};

export const checkIfLastPage = (logs: ActivityLog[], logsPerPage: number) => {
    return !logs.length || logs.length < logsPerPage;
};

export function getFiltersWithLogUser(logsFilter: LogsFilter | HistoryLogsFilter) {
    if (logsFilter.filterSettings.usernames.includes(SYSTEM_USER)) {
        return {
            ...logsFilter,
            filterSettings: {
                ...logsFilter.filterSettings,
                usernames: [...logsFilter.filterSettings.usernames, LOG_USER],
            },
        };
    }
    return logsFilter;
}

export const getActivityLogUserTitle = (user: User) => {
    const { username, fullName } = user;
    return SYSTEM_USERS.includes(username) ? SYSTEM_USER : fullName || username;
};

export const getActivityTypeLabel = (activityType: string): string => {
    return activityType.charAt(0).toUpperCase() + activityType.slice(1).replaceAll('_', ' ').toLowerCase();
};

export const checkIfMessageIsMarkdown = (activityType: string, message: string): boolean => {
    return (activityType === 'TRIGGER_EXECUTED' || activityType === 'TRIGGER_SKIPPED') && (message.includes('#/releases/') || message.includes('#/templates/'));
};

export const groupActivityLogsByDate = (logs: ActivityLog[]): ActivityLogGroupType => {
    return groupBy<ActivityLog>(logs, (log) => moment(log.eventTime).startOf('day').valueOf());
};
