import React from 'react';
import moment from 'moment';
import { DotPill, DotTooltip, DotTypography } from '@digital-ai/dot-components';
import { ActivityLog } from '../../../types';
import { formatDate } from '@xlr-ui/app/features/common/helper';
import { ActivityLogsUser } from '../../../components/activity-logs-user.component';
import { checkIfMessageIsMarkdown, getActivityLogUserTitle, getActivityTypeLabel } from '../../../helper';
import { ExpandableTypography } from '@xlr-ui/app/features/common/components/expandable-typography/expandable-typography.component';
import { TextAreaMarkdown } from '@xlr-ui/app/react/components/markdown/textarea-markdown.component';
import './drawer-history-row.component.less';

export interface DrawerHistoryRowProps {
    log: ActivityLog;
}

export const DrawerHistoryRow = ({ log }: DrawerHistoryRowProps) => {
    const { activityType, eventTime, message } = log;
    const userTitle = getActivityLogUserTitle(log.user);
    const activityTypeLabel = getActivityTypeLabel(activityType);
    const isRenderedAsMarkdown = checkIfMessageIsMarkdown(activityType, message);

    return (
        <div className="drawer-history-row">
            <div className="drawer-history-row-content-wrapper">
                <div className="drawer-history-row-content-left">
                    <ActivityLogsUser avatarSize="small" isNameHidden={true} title={userTitle} user={log.user} />
                </div>
                <div className="drawer-history-row-content-right">
                    <div className="content-right-header">
                        <DotTypography ariaLabel={userTitle} variant="body1">
                            {userTitle}
                        </DotTypography>
                        <DotTooltip title={formatDate(eventTime, 'short')}>
                            <span className="content-right-header-time">{moment(eventTime).fromNow()}</span>
                        </DotTooltip>
                    </div>
                    <div className="content-right-type">{<DotPill label={activityTypeLabel} size="small" variant="outlined" />}</div>
                    <div className="content-right-message">
                        {isRenderedAsMarkdown ? (
                            <TextAreaMarkdown inputId={`${activityType}-${eventTime}`} isReadOnly={true} name="history-log-message" rows={1} text={message} />
                        ) : (
                            <ExpandableTypography text={message} />
                        )}
                    </div>
                </div>
            </div>
        </div>
    );
};
