package com.xebialabs.xlrelease.handler

import com.xebialabs.xlrelease.builder.LogsFiltersBuilder
import com.xebialabs.xlrelease.domain.ActivityLogEntry
import com.xebialabs.xlrelease.repository.Ids.releaseIdFrom
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.service.ReleaseActivityLogsService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.data.domain.Pageable
import org.springframework.stereotype.Component

import java.util.{List => JList}

@Component
class ReleaseActivityLogsApiHandler @Autowired()(releaseActivityLogsService: ReleaseActivityLogsService, permissions: PermissionChecker)
  extends BaseActivityLogsApiHandler(releaseActivityLogsService, "release") {

  override def getActivityLogs(releaseId: String): JList[ActivityLogEntry] = {
    permissions.checkView(releaseId)
    searchLogs(releaseId)
  }
}


@Component
class TaskActivityLogsApiHandler @Autowired()(releaseActivityLogsService: ReleaseActivityLogsService, permissions: PermissionChecker)
  extends BaseActivityLogsApiHandler(releaseActivityLogsService, "task") {

  override def getActivityLogs(taskId: String): JList[ActivityLogEntry] = {
    val releaseId = releaseIdFrom(taskId)
    permissions.checkView(releaseId)
    releaseActivityLogsService.getFilteredLogs(releaseId, LogsFiltersBuilder.newLogsFilters().withTargetId(taskId).build(), Pageable.unpaged())
  }
}
