package com.xebialabs.xlrelease.activity

import com.xebialabs.deployit.util.PasswordEncrypter
import com.xebialabs.xlrelease.domain.ReleaseActivity._
import com.xebialabs.xlrelease.domain._
import com.xebialabs.xlrelease.domain.variables.Variable
import com.xebialabs.xlrelease.utils.Diff
import com.xebialabs.xlrelease.variable.VariableHelper.withVariableSyntax

import java.util.{Date, List => JList}
import scala.jdk.CollectionConverters._

object VariablesDiff {

  def getDiffLogEntries(timestamp: Date, username: String, before: JList[Variable], after: JList[Variable]): JList[ActivityLogEntry] = {
    Diff.applyWithKeyMapping(before.asScala, after.asScala)((_: Variable).getKey)
      .fold(List.empty[ActivityLogEntry])(
        onDeleted = {
          case (l, (key, variable)) =>
            l :+ RELEASE_VARIABLE_DELETED.create(timestamp, username, variable.getType, variable.getId, withVariableSyntax(key))
        },
        onNew = {
          case (l, (key, variable)) =>
            l :+ RELEASE_VARIABLE_CREATED.create(timestamp, username, variable.getType, variable.getId, withVariableSyntax(key))

        },
        onUpdated = {
          case (l, (_, (original, updated))) =>
            l ++ getDiffLogEntries(timestamp, username, original, updated)
        }
      ).asJava
  }

  def getDiffLogEntries(timestamp: Date, username: String, before: Variable, after: Variable): List[ActivityLogEntry] = {
    def diff(activityType: ReleaseActivity, key: String,
             value: Variable => String, showValues: Boolean = true): List[ActivityLogEntry] =
      if (value(before) == value(after)) {
        List.empty
      } else if (showValues) {
        List(activityType.create(timestamp, username, before.getType, before.getId, key, value(before), value(after)))
      } else {
        List(activityType.create(timestamp, username, before.getType, before.getId, key))
      }

    val oldKey: String = withVariableSyntax(before.getKey)
    val newKey: String = withVariableSyntax(after.getKey)

    val valueChangedActivity = if (before.isPassword) {
      diff(RELEASE_VARIABLE_PASSWORD_VALUE_UPDATED, newKey,
        v => PasswordEncrypter.getInstance().ensureDecrypted(v.getValueAsString), showValues = false)
    } else {
      diff(RELEASE_VARIABLE_VALUE_UPDATED, newKey, _.getValueAsString)
    }


    diff(RELEASE_VARIABLE_NAME_UPDATED, oldKey, _.getKey) ++
      valueChangedActivity ++
      diff(RELEASE_VARIABLE_LABEL_UPDATED, newKey, _.getLabel) ++
      diff(RELEASE_VARIABLE_DESCRIPTION_UPDATED, newKey, _.getDescription) ++
      diff(RELEASE_VARIABLE_REQUIRED_UPDATED, newKey, _.getRequiresValue.toString) ++
      diff(RELEASE_VARIABLE_SHOW_ON_CREATE_UPDATED, newKey, _.getShowOnReleaseStart.toString)
  }.toList
}
