package com.xebialabs.xlrelease.activity;

import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.ScriptTask;

import static com.google.common.base.Objects.equal;
import static com.xebialabs.xlrelease.domain.ReleaseActivity.TASK_SCRIPT_UPDATED;

@Component
public class ScriptTaskFieldsComparator implements TaskFieldsComparator<ScriptTask> {

    private DefaultTaskFieldsComparator defaultTaskFieldsComparator;

    @Autowired
    public ScriptTaskFieldsComparator(final DefaultTaskFieldsComparator defaultTaskFieldsComparator) {
        this.defaultTaskFieldsComparator = defaultTaskFieldsComparator;
    }

    @Override
    public Class<ScriptTask> getTaskClass() {
        return ScriptTask.class;
    }

    @Override
    public List<ActivityLogEntry> getLogs(Date timestamp, String username, final ScriptTask original, final ScriptTask updated) {
        List<ActivityLogEntry> updateLogs = defaultTaskFieldsComparator.getLogs(timestamp, username, original, updated);

        if (!equal(original.getScript(), updated.getScript())) {
            updateLogs.add(TASK_SCRIPT_UPDATED.create(timestamp, username, original.getTaskType(), original.getId(),
                    updated.getTitle(), original.getScript(), updated.getScript())
            );
        }

        return updateLogs;
    }
}
