import React from 'react';
import { DotPill } from '@digital-ai/dot-components';
import { calculateActivityLogColumnProps, checkIfMessageIsMarkdown } from '../../helper';
import { ExpandableTypography } from '@xlr-ui/app/features/common/components/expandable-typography/expandable-typography.component';
import { TextAreaMarkdown } from '@xlr-ui/app/react/components/markdown/textarea-markdown.component';
import './activity-logs-activity.component.less';

export interface ActivityLogsActivityProps {
    activityType: string;
    eventTime: number;
    message: string;
}

export const ActivityLogsActivity = ({ activityType, eventTime, message }: ActivityLogsActivityProps) => {
    const activityLogColumnProps = calculateActivityLogColumnProps(activityType, message);
    const activityLogMessage = activityLogColumnProps?.message ?? message;

    const isRenderedAsMarkdown = checkIfMessageIsMarkdown(activityType, message);

    const renderPlainTextMessage = () => <ExpandableTypography text={activityLogMessage} />;

    const renderMarkdownMessage = () => (
        <TextAreaMarkdown inputId={`${activityType}-${eventTime}`} isReadOnly={true} name="activity-message" rows={1} text={activityLogMessage} />
    );

    return (
        <div className="activity-logs-activity">
            {activityLogColumnProps ? (
                <DotPill
                    backgroundcolor={activityLogColumnProps.background}
                    bordercolor={activityLogColumnProps.border}
                    label={activityLogColumnProps.label}
                    size="small"
                    variant="outlined"
                />
            ) : null}
            {isRenderedAsMarkdown ? renderMarkdownMessage() : renderPlainTextMessage()}
        </div>
    );
};
