package com.xebialabs.xlrelease.activity

import com.xebialabs.xlrelease.domain.ReleaseActivity._
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe, XLReleaseEventBus}
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@EventListener
class DependencyLoggingEventHandler @Autowired()(val eventBus: XLReleaseEventBus, val activityLogRepository: ActivityLogRepository)
  extends ActivityLogger[DependencyEvent] {

  @Subscribe
  def onEvent(event: DependencyEvent): Unit = log(event)

  override def logEntries: PartialFunction[XLReleaseEvent, LoggingParams] = {
    case ev@DependencyCreatedEvent(dependency) =>
      LoggingParams(releaseIdFrom(dependency),
        None,
        DEPENDENCY_CREATED.create(ev, ev.dependency, dependency.getGateTask.getTitle, dependency.getTargetDisplayPath)
      )
    case ev@DependencyUpdatedEvent(original, updated) =>
      LoggingParams(releaseIdFrom(updated),
        None,
        DEPENDENCY_UPDATED.create(ev, ev.original, updated.getGateTask.getTitle, original.getTargetDisplayPath, updated.getTargetDisplayPath)
      )
    case ev@DependencyDeletedEvent(dependency) =>
      LoggingParams(releaseIdFrom(dependency),
        None,
        DEPENDENCY_DELETED.create(ev, ev.dependency, dependency.getGateTask.getTitle, dependency.getTargetDisplayPath)
      )
  }
}
