package com.xebialabs.xlrelease.activity

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.ReleaseActivity.{TASK_FACET_CREATED, TASK_FACET_DELETED, TASK_FACET_UPDATED}
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe, XLReleaseEventBus}
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import com.xebialabs.xlrelease.repository.Ids.isTaskId
import com.xebialabs.xlrelease.service.TaskService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@EventListener
class FacetActivityLoggingEventHandler @Autowired()(val eventBus: XLReleaseEventBus,
                                                    val activityLogRepository: ActivityLogRepository,
                                                    taskService: TaskService) extends ActivityLogger[FacetEvent] {

  @Subscribe
  def onEvent(event: FacetEvent): Unit = log(event)

  def logEntries: PartialFunction[XLReleaseEvent, LoggingParams] = {
    case ev@FacetCreatedEvent(facet) if isTaskId(facet.getTargetId) =>
      val taskId = facet.getTargetId
      LoggingParams(releaseIdFrom(taskId), None,
        TASK_FACET_CREATED.create(ev.timestamp, ev.username, Type.valueOf(taskService.getType(taskId)), taskId, taskService.getTitle(taskId), facet.getType.getName)
      )
    case ev@FacetUpdatedEvent(_, facet) if isTaskId(facet.getTargetId) =>
      val taskId = facet.getTargetId
      LoggingParams(releaseIdFrom(taskId), None,
        TASK_FACET_UPDATED.create(ev.timestamp, ev.username, Type.valueOf(taskService.getType(taskId)), taskId, taskService.getTitle(taskId), facet.getType.getName)
      )
    case ev@FacetDeletedEvent(facet) if isTaskId(facet.getTargetId) =>
      val taskId = facet.getTargetId
      LoggingParams(releaseIdFrom(taskId), None,
        TASK_FACET_DELETED.create(ev.timestamp, ev.username, Type.valueOf(taskService.getType(taskId)), taskId, taskService.getTitle(taskId), facet.getType.getName)
      )

  }

}
