import React from 'react';
import { DotChip, DotAvatar } from '@digital-ai/dot-components';
import { RELEASE_LOGO_SVG, SYSTEM_USER } from '../../constants';
import { mountWithTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { UserChip, UserChipProps } from './user-chip.component';

describe('UserChip', () => {
    const onDelete = jest.fn();
    let wrapper: ReactWrapper;

    const getChip = () => wrapper.find(DotChip);
    const getAvatar = () => wrapper.find(DotAvatar);

    const defaultProps: UserChipProps = {
        onDelete,
        value: { id: 'admin', title: 'Release admin' },
    };

    const mount = (props: UserChipProps = defaultProps) => {
        wrapper = mountWithTheme(<UserChip {...props} />);
    };

    it('should render avatar of the user', () => {
        mount();
        const chip = getChip().props();
        const avatar = getAvatar().props();

        expect(chip.size).toBe('small');
        expect(chip.children).toBe('Release admin');

        expect(avatar.alt).toBe('Image for user Release admin');
        expect(avatar.imageSrc).toBeUndefined();
        expect(avatar.size).toBe('small');
        expect(avatar.text).toBe('Release admin');
        expect(avatar.type).toBe('text');
    });

    it('should render release logo for SYSTEM_USER', () => {
        mount({ ...defaultProps, value: { id: SYSTEM_USER, title: SYSTEM_USER } });
        const chip = getChip().props();
        const avatar = getAvatar().props();

        expect(chip.size).toBe('small');
        expect(chip.children).toBe(SYSTEM_USER);

        expect(avatar.alt).toBe(`Image for user ${SYSTEM_USER}`);
        expect(avatar.imageSrc).toBe(RELEASE_LOGO_SVG);
        expect(avatar.size).toBe('small');
        expect(avatar.text).toBe(SYSTEM_USER);
        expect(avatar.type).toBe('image');
    });

    it('should handle onDelete callback', () => {
        mount();
        getChip().invoke('onDelete')();
        expect(onDelete).toHaveBeenCalledWith('admin');
    });
});
