import React, { HTMLAttributes } from 'react';
import { DotAutoComplete } from '@digital-ai/dot-components';
import { IdAutoCompleteOption } from '@xlr-ui/app/features/tasks/types';
import { AvatarWithName } from '@xlr-ui/app/features/tasks/components/common/avatar-with-name.component';
import { User } from '@xlr-ui/app/types';
import { UserChip } from './user-chip.component';
import { getSystemUserAvatar } from '../../helper';

export interface FilterUsernameProps {
    inputId: string;
    onChange: (usernames: string[]) => void;
    placeholder: string;
    users: User[];
    value: string[];
}

export const FilterUsername = ({ inputId, onChange, placeholder, users, value }: FilterUsernameProps) => {
    const usernamesOptions: IdAutoCompleteOption[] = users
        .map((currentUsername) => ({
            id: currentUsername.username,
            title: currentUsername.fullName || currentUsername.username,
        }))
        .sort((a, b) => a.title.localeCompare(b.title));
    const selectedOptions: IdAutoCompleteOption[] = usernamesOptions.filter((currentUsername) => value.includes(currentUsername.id));

    const handleDelete = (userId: string) => {
        onChange(value.filter((u) => u !== userId));
    };

    function renderTags(options: IdAutoCompleteOption[]) {
        return options.map((user) => <UserChip key={user.id} onDelete={handleDelete} value={user} />);
    }

    function renderOptions(props: HTMLAttributes<HTMLLIElement>, { title, id }: IdAutoCompleteOption) {
        return (
            <li key={id} {...props}>
                <AvatarWithName avatarImgSrc={getSystemUserAvatar(id)} id={id} title={title} />
            </li>
        );
    }

    return (
        <DotAutoComplete
            freesolo={false}
            inputId={inputId}
            isOptionEqualToValue={(option: IdAutoCompleteOption, v: IdAutoCompleteOption) => option.id === v.id}
            multiple={true}
            onChange={(_ev, newValue) => {
                const selectedUsernames = (newValue as IdAutoCompleteOption[]).map((v) => v.id);
                onChange(selectedUsernames);
            }}
            options={usernamesOptions}
            placeholder={placeholder}
            renderOption={renderOptions}
            renderTags={renderTags}
            value={selectedOptions}
        />
    );
};
