import React from 'react';
import { AvatarWithName } from '@xlr-ui/app/features/tasks/components/common/avatar-with-name.component';
import { User } from '@xlr-ui/app/types';
import { LOG_USER, RELEASE_LOGO_SVG, SYSTEM_USER } from '../../constants';

export interface ActivityLogsUserProps {
    user: User;
}

export const SYSTEM_USERS = [SYSTEM_USER, LOG_USER];

export const ActivityLogsUser = ({ user }: ActivityLogsUserProps) => {
    const { username, fullName } = user;
    const avatarImgSrc = SYSTEM_USERS.includes(username) ? RELEASE_LOGO_SVG : undefined;
    const title = SYSTEM_USERS.includes(username) ? SYSTEM_USER : fullName || username;
    return <AvatarWithName avatarImgSrc={avatarImgSrc} id={username} title={title} />;
};
