import React from 'react';
import moment from 'moment';
import { DotInputText } from '@digital-ai/dot-components';

export interface FilterDateProps {
    inputId: string;
    onChange: (date: number | null) => void;
    value: number | null;
}

export const FilterDate = ({ inputId, onChange, value }: FilterDateProps) => {
    const date = value ? moment.utc(value).local().format('YYYY-MM-DDTHH:mm') : undefined;
    return (
        <DotInputText
            id={inputId}
            name={inputId}
            onChange={(e) => {
                const unixTimestamp = e.target.value ? moment(e.target.value).local().utc().valueOf() : null;
                onChange(unixTimestamp);
            }}
            type="datetime-local"
            value={date}
        />
    );
};
