import React from 'react';
import { DotLink, DotTypography } from '@digital-ai/dot-components';
import { getDeliveryUrlFromPath, getTargetTypeLabel } from '../../helper';
import { ActivityLogsContainerEnum } from '../../types';

export interface ActivityLogsTypeDeliveryProps {
    targetId: string;
    targetType: string;
}

export const ActivityLogsTypeDelivery = ({ targetId, targetType }: ActivityLogsTypeDeliveryProps) => {
    return targetType === 'delivery.Delivery' ? (
        <DotLink href={getDeliveryUrlFromPath(targetId)}>Delivery</DotLink>
    ) : (
        <DotTypography data-testid="type-label-typography" variant="body1">
            {getTargetTypeLabel(targetType, ActivityLogsContainerEnum.DELIVERY)}
        </DotTypography>
    );
};
