package com.xebialabs.xlrelease.activity

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.domain.ActivityLogEntry
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.user.User

import java.util.{List => JList}
import scala.jdk.CollectionConverters._
import scala.language.implicitConversions

trait ActivityLogEntryFactory {

  def logEntries: PartialFunction[XLReleaseEvent, LoggingParams]

  def releaseIdFrom(id: String): Option[String] = Option(Ids.releaseIdFrom(id))

  def releaseIdFrom(configurationItem: ConfigurationItem): Option[String] = Option(Ids.releaseIdFrom(configurationItem.getId))

  implicit def logEntriesToList(entries: JList[ActivityLogEntry]): List[ActivityLogEntry] = entries.asScala.toList

  implicit def logEntryToList(entry: ActivityLogEntry): List[ActivityLogEntry] = List(entry)

  implicit def userToString(user: User): Option[String] = Option(user.getName)
}
