import React from 'react';
import { DotAutoComplete } from '@digital-ai/dot-components';
import { AvatarWithName } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/components/common/avatar-with-name.component';
import { User } from '../../../../../../../../../../core/xlr-ui/app/types';
import { mockResizeObserver, mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { FilterUsername, FilterUsernameProps } from './filter-username.component';
import { RELEASE_LOGO_SVG, SYSTEM_USER } from '../../constants';
import { UserChip } from './user-chip.component';

describe('FilterUsername', () => {
    const users: User[] = [{ username: 'user1' }, { username: SYSTEM_USER }];
    const onChange = jest.fn();
    let wrapper: ReactWrapper;

    const defaultProps: FilterUsernameProps = {
        inputId: 'input-id',
        onChange,
        placeholder: 'placeholder',
        users,
        value: ['user1'],
    };

    const user1 = {
        id: 'user1',
        title: 'user1',
    };

    const getAutocomplete = () => wrapper.find(DotAutoComplete);
    const openAutocomplete = () => getAutocomplete().find('input').simulate('mousedown');
    const getAvatar = (id: string) => wrapper.findWhere((node) => node.is(AvatarWithName) && node.prop('id') === id);

    const mount = (props: FilterUsernameProps = defaultProps) => {
        wrapper = mountWithTheme(<FilterUsername {...props} />);
    };

    beforeEach(() => {
        mockResizeObserver();
    });

    it('should render default props', () => {
        mount();
        const autocompleteProps = getAutocomplete().props();
        expect(autocompleteProps.freesolo).toStrictEqual(false);
        expect(autocompleteProps.inputId).toStrictEqual(defaultProps.inputId);
        expect(autocompleteProps.multiple).toStrictEqual(true);
        expect(autocompleteProps.options).toStrictEqual([
            {
                id: SYSTEM_USER,
                title: SYSTEM_USER,
            },
            user1,
        ]);
        expect(autocompleteProps.placeholder).toStrictEqual(defaultProps.placeholder);
        expect(autocompleteProps.value).toStrictEqual([user1]);
    });

    it('should render SYSTEM user with logo', () => {
        mount();
        openAutocomplete();
        const systemAvatarProps = getAvatar(SYSTEM_USER).props();
        expect(systemAvatarProps.title).toStrictEqual(SYSTEM_USER);
        expect(systemAvatarProps.avatarImgSrc).toStrictEqual(RELEASE_LOGO_SVG);
    });

    it('should render selected options as chips', () => {
        mount();
        const userChip = wrapper.find(UserChip);
        expect(userChip).toHaveLength(1);
        const userChipProps = userChip.props();
        expect(userChipProps.className).toBe('autocomplete-user-chip');
        expect(userChipProps.onDelete).toStrictEqual(expect.any(Function));
        expect(userChipProps.value).toStrictEqual(user1);
        userChip.invoke('onDelete')(user1.id);
        expect(onChange).toHaveBeenCalledWith([]);
    });

    it('should handle onChange', () => {
        mount();
        wrapper.find(DotAutoComplete).prop('onChange')({}, [{ id: SYSTEM_USER }]);
        expect(onChange).toHaveBeenCalledWith([SYSTEM_USER]);
    });
});
