import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import noop from 'lodash/noop';
import { RootState } from '../../../../../../../../../core/xlr-ui/app/js/store.types';
import { ActivityLog, ActivityLogsContainerEnum, ActivityLogsFilterSettings } from '../types';
import { User } from '../../../../../../../../../core/xlr-ui/app/types';
import { DEFAULT_FILTER_SETTINGS } from '../constants';

export interface LoadFilteredAndPagedLogsAction {
    logsFilter: LogsFilter;
    page: number;
}

export interface LogsFilter {
    containerEnum: ActivityLogsContainerEnum;
    containerId: string;
    filterSettings: ActivityLogsFilterSettings;
}

export interface ActivityLogsState {
    activityTypes: string[];
    eventDetails?: string;
    isDrawerOpened: boolean;
    isEventDialogOpened: boolean;
    isLastPage: boolean;
    isLoading: boolean;
    logs: ActivityLog[];
    logsFilter: LogsFilter;
    page: number;
    users: User[];
}

export const initialState: ActivityLogsState = {
    activityTypes: [],
    logsFilter: {
        containerEnum: ActivityLogsContainerEnum.RELEASE,
        containerId: '',
        filterSettings: DEFAULT_FILTER_SETTINGS,
    },
    page: 0,
    isDrawerOpened: false,
    isEventDialogOpened: false,
    isLastPage: false,
    isLoading: false,
    logs: [],
    users: [],
};

export const activityLogs = createSlice({
    name: 'activityLogs',
    initialState,
    reducers: {
        init: (_state, _action: PayloadAction<LogsFilter>) => noop(),
        loadFilteredAndPagedLogs: (_state, _action: PayloadAction<LoadFilteredAndPagedLogsAction>) => noop(),
        setLogsFilter: (state, action: PayloadAction<LogsFilter>) => {
            state.logsFilter = action.payload;
        },
        setLogs: (state, action: PayloadAction<ActivityLog[]>) => {
            state.logs = action.payload;
        },
        setHighlightImportant: (_state, _action: PayloadAction<boolean>) => noop(),
        setPage: (state, action: PayloadAction<number>) => {
            state.page = action.payload;
        },
        setIsLastPage: (state, action: PayloadAction<boolean>) => {
            state.isLastPage = action.payload;
        },
        setIsLoading: (state, action: PayloadAction<boolean>) => {
            state.isLoading = action.payload;
        },
        setIsDrawerOpened: (state, action: PayloadAction<boolean>) => {
            state.isDrawerOpened = action.payload;
        },
        setActivityTypes: (state, action: PayloadAction<string[]>) => {
            state.activityTypes = action.payload;
        },
        setUsers: (state, action: PayloadAction<User[]>) => {
            state.users = action.payload;
        },
        loadEventDialog: (_state, _action: PayloadAction<string>) => noop(),
        closeEventDialog: (state) => {
            state.isEventDialogOpened = false;
            state.eventDetails = undefined;
        },
        setEventDialogOpened: (state, action: PayloadAction<boolean>) => {
            state.isEventDialogOpened = action.payload;
        },
        setEventDetails: (state, action: PayloadAction<string>) => {
            state.eventDetails = action.payload;
        },
        reset: () => initialState,
    },
});

export const getActivityLogsState = (state: RootState): ActivityLogsState => state.activityLogs;
